/*
 * Decompiled with CFR 0.152.
 */
package de.vw.vaudes.diaghook;

import de.vw.vaudes.diaghook.BrandNotFoundException;
import de.vw.vaudes.diaghook.DiagnosticDataIndicationException;
import de.vw.vaudes.diaghook.IllegalVersionForBrandException;
import de.vw.vaudes.diaghook.activator.Activator;
import de.vw.vaudes.diaghook.cache.TextCache;
import de.vw.vaudes.diaghook.index.ObjectIndicator;
import de.vw.vaudes.diaghook.index.db.DatabaseResolver;
import de.vw.vaudes.diaghook.index.fkc.FunctiontestIndicator;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DiagnosticDataHook {
    private static final Log LOGGER = LogFactory.getLog(DiagnosticDataHook.class);
    private final Set<URI> fAtpUrlList = new HashSet<URI>();
    private final Set<URI> fHotfixUrlList = new HashSet<URI>();
    private String fBaselineVersion;
    private String fTestbaselineVersion;
    private URI fDbRessourceLocation;
    private static final DiagnosticDataHook INSTANCE = new DiagnosticDataHook();

    private DiagnosticDataHook() {
    }

    public static DiagnosticDataHook getInstance() {
        return INSTANCE;
    }

    public void indicateHotfix(URL uRL) throws DiagnosticDataIndicationException {
        if (uRL == null) {
            LOGGER.warn((Object)"Received non-valid Url to indicate");
            throw new DiagnosticDataIndicationException(DiagnosticDataIndicationException.ErrorId.URL_INVALID);
        }
        LOGGER.info((Object)("Hotfix data added: " + uRL.toExternalForm()));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"... start with data indication ...");
        }
        try {
            ObjectIndicator.getInstance().indicateHotfix(uRL);
            this.getHotfixUrlList().add(uRL.toURI());
        }
        catch (Exception exception) {
            LOGGER.error((Object)("Error handling url " + uRL), (Throwable)exception);
            if (exception instanceof DiagnosticDataIndicationException) {
                throw (DiagnosticDataIndicationException)exception;
            }
            throw new DiagnosticDataIndicationException(DiagnosticDataIndicationException.ErrorId.PATH_NOT_FOUND_OR_READABLE, (Throwable)exception);
        }
        if (null != Activator.getDefault()) {
            Activator.getDefault().registerFactoryHookServices();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Indication of " + uRL.toExternalForm() + " ended"));
        }
    }

    public void indicateAtp(URL uRL) throws DiagnosticDataIndicationException {
        if (uRL == null) {
            LOGGER.warn((Object)"Received non-valid Url to indicate");
            throw new DiagnosticDataIndicationException(DiagnosticDataIndicationException.ErrorId.URL_INVALID);
        }
        LOGGER.info((Object)("ATP data added: " + uRL.toExternalForm()));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"... start with data indication ...");
        }
        try {
            ObjectIndicator.getInstance().indicateGfs(uRL);
            this.getAtpUrlList().add(uRL.toURI());
        }
        catch (Exception exception) {
            LOGGER.error((Object)("Error handling url " + uRL), (Throwable)exception);
            if (exception instanceof DiagnosticDataIndicationException) {
                throw (DiagnosticDataIndicationException)exception;
            }
            throw new DiagnosticDataIndicationException(DiagnosticDataIndicationException.ErrorId.PATH_NOT_FOUND_OR_READABLE, (Throwable)exception);
        }
        if (null != Activator.getDefault()) {
            Activator.getDefault().registerFactoryHookServices();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Indication of " + uRL.toExternalForm() + " ended"));
        }
    }

    public void refreshIndex() throws DiagnosticDataIndicationException {
        URL uRL;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Refresh of index started ... ");
        }
        this.clearIndex();
        Iterator<URI> iterator = this.getAtpUrlList().iterator();
        while (iterator.hasNext()) {
            uRL = null;
            try {
                ObjectIndicator.getInstance().indicateGfs(iterator.next().toURL());
            }
            catch (Exception exception) {
                LOGGER.error((Object)("Error handling URL " + uRL), (Throwable)exception);
                if (exception instanceof DiagnosticDataIndicationException) {
                    throw (DiagnosticDataIndicationException)exception;
                }
                if (exception instanceof MalformedURLException) {
                    throw new DiagnosticDataIndicationException(DiagnosticDataIndicationException.ErrorId.URL_INVALID, (Throwable)exception);
                }
                throw new DiagnosticDataIndicationException(DiagnosticDataIndicationException.ErrorId.PATH_NOT_FOUND_OR_READABLE, (Throwable)exception);
            }
        }
        iterator = this.getHotfixUrlList().iterator();
        while (iterator.hasNext()) {
            uRL = null;
            try {
                ObjectIndicator.getInstance().indicateHotfix(iterator.next().toURL());
            }
            catch (Exception exception) {
                LOGGER.error((Object)("Error handling URL " + uRL), (Throwable)exception);
                if (exception instanceof DiagnosticDataIndicationException) {
                    throw (DiagnosticDataIndicationException)exception;
                }
                if (exception instanceof MalformedURLException) {
                    throw new DiagnosticDataIndicationException(DiagnosticDataIndicationException.ErrorId.URL_INVALID, (Throwable)exception);
                }
                throw new DiagnosticDataIndicationException(DiagnosticDataIndicationException.ErrorId.PATH_NOT_FOUND_OR_READABLE, (Throwable)exception);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Refresh of index ended ... ");
        }
    }

    private void clearIndex() {
        ObjectIndicator.getInstance().clearIndex();
        FunctiontestIndicator.getInstance().clearIndex();
    }

    public void reset() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Reset of index started ... ");
        }
        this.clearIndex();
        this.getAtpUrlList().clear();
        this.getHotfixUrlList().clear();
        ObjectIndicator.getInstance().reset();
        this.fDbRessourceLocation = null;
        Activator.getDefault().unregisterFactoryHookServices();
        DatabaseResolver.getInstance().reset();
        TextCache.getInstance().reset();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Reset of index ended ... ");
        }
    }

    public void setBaselineVersion(String string, String string2, String string3) throws IllegalVersionForBrandException, BrandNotFoundException {
        Object object;
        if (null == string2 || null == string3) {
            throw new IllegalArgumentException("Baseline version(s) must not be null");
        }
        if (!string2.matches("[0-9]+\\.[0-9]+\\.[0-9]+")) {
            LOGGER.error((Object)("Baseline version '" + string2 + "' does not match pattern [0-9]+\\.[0-9]+\\.[0-9]"));
            throw new IllegalArgumentException("Baseline version must match pattern [0-9]+\\.[0-9]+\\.[0-9]+");
        }
        if (!string3.matches("[0-9]+\\.[0-9]+\\.[0-9]+")) {
            LOGGER.error((Object)("Test baseline version '" + string3 + "' does not match pattern [0-9]+\\.[0-9]+\\.[0-9]"));
            throw new IllegalArgumentException("Test baseline version must match pattern [0-9]+\\.[0-9]+\\.[0-9]+");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("DiagnosticDataHook.setBaselineVersion(" + string + ", " + string2 + ", " + string3 + ")"));
        }
        this.fBaselineVersion = string2;
        boolean bl = false;
        try {
            object = StringUtils.split((String)string2, (String)".");
            if (((String[])object).length > 0) {
                bl = Integer.parseInt(object[0]) >= 500;
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Error on determining testbaseline modus", (Throwable)exception);
        }
        ObjectIndicator.getInstance().setTestbaselineMode(bl);
        this.fTestbaselineVersion = string3;
        ObjectIndicator.getInstance().setBaselineVersion(this.fBaselineVersion);
        ObjectIndicator.getInstance().setTestbaselineVersion(this.fTestbaselineVersion);
        LOGGER.info((Object)("Brand set to " + string));
        LOGGER.info((Object)("Baseline version set to " + this.fBaselineVersion));
        LOGGER.info((Object)("Test baseline version set to " + this.fTestbaselineVersion));
        if (DatabaseResolver.getInstance().isDatabaseAvailable()) {
            if (null == string || string.length() == 0) {
                throw new IllegalArgumentException("Brand (KVPS-key) must not be null/empty");
            }
            try {
                object = "";
                String string4 = "";
                if (!string2.equals("0.0.0")) {
                    object = string2;
                }
                if (!string3.equals("0.0.0")) {
                    string4 = string3;
                }
                DatabaseResolver.getInstance().setBaseline(string, (String)object, string4);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Set brand '" + string + "' to database component"));
                    LOGGER.debug((Object)("Set baseline '" + (String)object + "' to database component"));
                    LOGGER.debug((Object)("Set test baseline '" + string4 + "' to database component"));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.error((Object)illegalArgumentException);
                throw new IllegalVersionForBrandException();
            }
        }
    }

    public void setBrand(String string) throws BrandNotFoundException {
        if (null == string || string.length() == 0) {
            throw new IllegalArgumentException("Brand (KVPS-key) must be non null/no empty string");
        }
        try {
            ObjectIndicator.getInstance().setBrand(string);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("DiagnosticDataHook.setBrand(" + string + ")"));
            }
            if (DatabaseResolver.getInstance().isDatabaseAvailable()) {
                DatabaseResolver.getInstance().setBrand(string);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Set brand " + string + " in database component"));
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.error((Object)("Brand (kvps key) does not exist in docbase: " + string));
            throw new BrandNotFoundException(string);
        }
    }

    public void createCache(String string) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("createCache(" + string + ")"));
        }
        if (DatabaseResolver.getInstance().isDatabaseAvailable()) {
            DatabaseResolver.getInstance().createCache(string);
        }
    }

    private Set<URI> getAtpUrlList() {
        return this.fAtpUrlList;
    }

    private Set<URI> getHotfixUrlList() {
        return this.fHotfixUrlList;
    }

    public void setDatabaseRessourceLocation(URI uRI) {
        this.fDbRessourceLocation = uRI;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Recieved resource location " + uRI));
        }
    }

    public URI getDatabaseRessourceLocation() {
        return this.fDbRessourceLocation;
    }

    public void setOfflineMode(boolean bl) {
        DatabaseResolver.getInstance().setOfflineMode(bl);
        if (bl) {
            LOGGER.info((Object)"Creator Database setted to offline");
        } else {
            LOGGER.info((Object)"Creator Database setted to online");
        }
    }
}

