/*
 * Decompiled with CFR 0.152.
 */
package de.vw.vaudes.diaghook.factory;

import de.volkswagen.odis.vaudas.core.exception.OdisBaseException;
import de.volkswagen.odis.vaudas.domainmodel.base.bean.ITextId;
import de.volkswagen.odis.vaudas.domainmodel.base.bean.ITranslatedText;
import de.volkswagen.odis.vaudas.domainmodel.base.factory.ITranslatedTextFactory;
import de.vw.vaudes.diaghook.cache.TextCache;
import de.vw.vaudes.diaghook.da.NonUniqueResultException;
import de.vw.vaudes.diaghook.index.IndicatedElement;
import de.vw.vaudes.diaghook.index.ObjectIndicator;
import de.vw.vaudes.diaghook.index.db.DatabaseResolver;
import de.vw.vaudes.diaghook.index.fkc.FkcMetaData;
import de.vw.vaudes.diaghook.index.fkc.FunctiontestIndicator;
import de.vw.vaudes.diaghook.transform.DbgHookTransformHelper;
import de.vw.vaudes.diaghook.transform.EfaTransformHelper;
import de.vw.vaudes.diaghook.transform.TranslatedTextTransformHelper;
import de.vw.vaudes.diaghook.util.Pair;
import de.vw.vaudes.diaghook.util.Validate;
import de.vw.vaudes.xml.stringtable.String;
import de.vw.vaudes.xml.stringtable.VAUDESStringTabelle;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TranslatedTextFactoryImpl
implements ITranslatedTextFactory {
    private final Log fLogger = LogFactory.getLog(this.getClass());

    public ITranslatedText getTranslatedText(Locale locale, ITextId iTextId, ITranslatedText iTranslatedText) throws OdisBaseException {
        boolean bl;
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getTranslatedText(" + locale + ", " + iTextId + ", " + iTranslatedText + ")"));
        }
        Validate.notNull(locale);
        Validate.notNull(iTextId);
        ITranslatedText iTranslatedText2 = TextCache.getInstance().get(iTextId, locale);
        if (null != iTranslatedText2) {
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return cached " + iTranslatedText2));
            }
            return iTranslatedText2;
        }
        boolean bl2 = bl = iTranslatedText != null;
        if (null == iTextId.getSource()) {
            this.fLogger.error((Object)"textId source not given. Can't determine translation text for emtpy source.");
            if (bl) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return " + iTranslatedText));
                }
                return iTranslatedText;
            }
            throw DbgHookTransformHelper.createOdisBaseException(iTextId.getSource());
        }
        try {
            if (DatabaseResolver.getInstance().isDatabaseAvailable() && (iTextId.getSource().equalsIgnoreCase("EfaCodes") || TranslatedTextTransformHelper.getTextSourceObjectFor(iTextId.getSource()).equalsIgnoreCase("EfaCodes")) && ObjectIndicator.getInstance().getObjectByIdOrSysName("EfaCodes") != null) {
                this.fLogger.info((Object)"Efa texts requested ... got Efa texts from Docbase and Hook scope");
                ITranslatedText iTranslatedText3 = null;
                try {
                    iTranslatedText3 = EfaTransformHelper.getEfaText(iTextId.getId(), locale);
                }
                catch (Exception exception) {
                    this.fLogger.error((Object)exception);
                }
                if (null != iTranslatedText3) {
                    if (this.fLogger.isDebugEnabled()) {
                        this.fLogger.debug((Object)("return new " + iTranslatedText3));
                    }
                    TextCache.getInstance().add(iTextId, iTranslatedText3);
                    return iTranslatedText3;
                }
                if (bl) {
                    if (this.fLogger.isDebugEnabled()) {
                        this.fLogger.debug((Object)("return " + iTranslatedText));
                    }
                    return iTranslatedText;
                }
                throw DbgHookTransformHelper.createOdisBaseException(TranslatedTextTransformHelper.createEmptyDto(locale, iTextId));
            }
            IndicatedElement indicatedElement = null;
            try {
                indicatedElement = ObjectIndicator.getInstance().getObjectByIdOrSysName(TranslatedTextTransformHelper.getTextSourceObjectFor(iTextId.getSource()));
            }
            catch (Exception exception) {
                this.fLogger.error((Object)("Error occurred while parsing object with id " + iTextId.getSource() + " from index."), (Throwable)exception);
            }
            if (null == indicatedElement) {
                ITranslatedText iTranslatedText4;
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)"requested object not found in regular index, looking for \"access without object\".");
                }
                Pair<VAUDESStringTabelle, FkcMetaData> pair = FunctiontestIndicator.getInstance().getFkcMetaDataFor(iTextId.getSource());
                try {
                    if (null != pair && null != pair.getFirst() && null != pair.getFirst().getString()) {
                        iTranslatedText4 = pair.getFirst().getString().iterator();
                        while (iTranslatedText4.hasNext()) {
                            String string = (String)iTranslatedText4.next();
                            if (!string.getId().equalsIgnoreCase(iTextId.getId())) continue;
                            ITranslatedText iTranslatedText5 = TranslatedTextTransformHelper.createTranslatedText(string);
                            iTranslatedText5.setTextSource(iTextId.getSource());
                            if (this.fLogger.isDebugEnabled()) {
                                this.fLogger.debug((Object)("return new " + iTranslatedText5));
                            }
                            return iTranslatedText5;
                        }
                    }
                }
                catch (Exception exception) {
                    this.fLogger.error((Object)exception);
                }
                if (DatabaseResolver.getInstance().isDatabaseAvailable()) {
                    try {
                        if (this.fLogger.isDebugEnabled()) {
                            this.fLogger.debug((Object)"query database resolver");
                        }
                        if (null != (iTranslatedText4 = DatabaseResolver.getInstance().getTranslatedText(iTextId.getSource(), locale, iTextId))) {
                            if (this.fLogger.isDebugEnabled()) {
                                this.fLogger.debug((Object)("return new " + iTranslatedText4));
                            }
                            TextCache.getInstance().add(iTextId, iTranslatedText4);
                            return iTranslatedText4;
                        }
                        if (bl) {
                            if (this.fLogger.isDebugEnabled()) {
                                this.fLogger.debug((Object)("return " + iTranslatedText));
                            }
                            return iTranslatedText;
                        }
                        throw DbgHookTransformHelper.createOdisBaseException(TranslatedTextTransformHelper.createEmptyDto(locale, iTextId));
                    }
                    catch (NonUniqueResultException nonUniqueResultException) {
                        throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
                    }
                }
                if (bl) {
                    if (this.fLogger.isDebugEnabled()) {
                        this.fLogger.debug((Object)("return " + iTranslatedText));
                    }
                    return iTranslatedText;
                }
                throw DbgHookTransformHelper.createOdisBaseException(TranslatedTextTransformHelper.createEmptyDto(locale, iTextId));
            }
            ITranslatedText iTranslatedText6 = TranslatedTextTransformHelper.getTranslatedTextFrom(indicatedElement, locale, iTextId);
            if (null != iTranslatedText6) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return new " + iTranslatedText6));
                }
                TextCache.getInstance().add(iTextId, iTranslatedText6);
                return iTranslatedText6;
            }
            ITranslatedText iTranslatedText7 = DatabaseResolver.getInstance().getTranslatedText(iTextId.getSource(), locale, iTextId);
            if (iTranslatedText7 == null) {
                if (bl) {
                    if (this.fLogger.isDebugEnabled()) {
                        this.fLogger.debug((Object)("return " + iTranslatedText));
                    }
                    return iTranslatedText;
                }
                throw DbgHookTransformHelper.createOdisBaseException(TranslatedTextTransformHelper.createEmptyDto(locale, iTextId));
            }
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return new " + iTranslatedText6));
            }
            TextCache.getInstance().add(iTextId, iTranslatedText6);
            return iTranslatedText7;
        }
        catch (Exception exception) {
            if (!(exception instanceof OdisBaseException)) {
                this.fLogger.error((Object)("Error while parsing text id " + iTextId.getId() + " for source " + iTextId.getSource()), (Throwable)exception);
            }
            if (bl) {
                return iTranslatedText;
            }
            throw DbgHookTransformHelper.createOdisBaseException(iTextId.getSource());
        }
    }

    public List<ITranslatedText> getTranslatedTexts(Locale locale, java.lang.String string, List<ITranslatedText> list) throws OdisBaseException {
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getTranslatedTexts(" + locale + ", " + string + ", " + list + ")"));
        }
        Validate.notNull(locale);
        Validate.notNull(string);
        Validate.notEmpty(string);
        if (null == list) {
            list = new ArrayList<ITranslatedText>();
        }
        IndicatedElement indicatedElement = null;
        try {
            indicatedElement = ObjectIndicator.getInstance().getObjectByIdOrSysName(TranslatedTextTransformHelper.getTextSourceObjectFor(string));
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error occurred while parsing object with id " + string + " from index"), (Throwable)exception);
        }
        if (null == indicatedElement) {
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)"requested object not found in regular index, looking for \"access without object\"");
            }
            Pair<VAUDESStringTabelle, FkcMetaData> pair = FunctiontestIndicator.getInstance().getFkcMetaDataFor(string);
            ArrayList<ITranslatedText> arrayList = new ArrayList<ITranslatedText>();
            try {
                if (null != pair && null != pair.getFirst().getString()) {
                    for (String string2 : pair.getFirst().getString()) {
                        ITranslatedText iTranslatedText = TranslatedTextTransformHelper.createTranslatedText(string2);
                        iTranslatedText.setTextSource(string);
                        if (this.fLogger.isDebugEnabled()) {
                            this.fLogger.debug((Object)("create new " + iTranslatedText));
                        }
                        arrayList.add(iTranslatedText);
                    }
                    TranslatedTextTransformHelper.mergeTranslatedTexts(list, arrayList);
                    if (this.fLogger.isDebugEnabled()) {
                        this.fLogger.debug((Object)("return merged " + list));
                    }
                    return list;
                }
                if (DatabaseResolver.getInstance().isDatabaseAvailable()) {
                    if (this.fLogger.isDebugEnabled()) {
                        this.fLogger.debug((Object)"query database resolver");
                    }
                    List<ITranslatedText> list2 = DatabaseResolver.getInstance().getTranslatedTexts(string, locale);
                    TranslatedTextTransformHelper.mergeTranslatedTexts(list, list2);
                    return list;
                }
                return list;
            }
            catch (NonUniqueResultException nonUniqueResultException) {
                throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
            }
            catch (Exception exception) {
                return list;
            }
        }
        try {
            List<ITranslatedText> list3 = TranslatedTextTransformHelper.getTranslatedTextsFrom(indicatedElement, locale);
            TranslatedTextTransformHelper.mergeTranslatedTexts(list, list3);
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return merged " + list));
            }
            return list;
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error while parsing texts for object id " + string), (Throwable)exception);
            return list;
        }
    }
}

