/*
 * Decompiled with CFR 0.152.
 */
package de.vw.vaudes.diaghook.index.ext;

import de.vw.vaudes.diaghook.DiagnosticDataIndicationException;
import de.vw.vaudes.diaghook.index.IndicatedElement;
import de.vw.vaudes.diaghook.index.ext.rule.IExtendedIndicationRule;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ExtendedDataIndicator {
    private final Log fLogger = LogFactory.getLog(this.getClass());
    private Set<IExtendedIndicationRule> fRules = new HashSet<IExtendedIndicationRule>();

    public void addRule(IExtendedIndicationRule iExtendedIndicationRule) {
        this.fRules.add(iExtendedIndicationRule);
    }

    public void indicate(Map<String, IndicatedElement> map) throws DiagnosticDataIndicationException {
        for (IExtendedIndicationRule iExtendedIndicationRule : this.fRules) {
            try {
                iExtendedIndicationRule.run(map);
            }
            catch (Exception exception) {
                this.fLogger.error((Object)("Error during extended data indication. Rule is %s" + iExtendedIndicationRule.toString()), (Throwable)exception);
                throw new DiagnosticDataIndicationException(DiagnosticDataIndicationException.ErrorId.PATH_NOT_FOUND_OR_READABLE, (Throwable)exception);
            }
        }
    }

    public static File resolveFile(URL uRL) {
        File file = null;
        try {
            file = new File(uRL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            file = new File(uRL.getPath());
        }
        return file;
    }
}

