/*
 * Decompiled with CFR 0.152.
 */
package de.vw.vaudes.diaghook.transform;

import de.volkswagen.odis.vaudas.domainmodel.base.bean.IOdisEcuReference;
import de.volkswagen.odis.vaudas.domainmodel.diag.bean.IEquipmentNode;
import de.vw.vaudes.diaghook.da.NonUniqueResultException;
import de.vw.vaudes.diaghook.dto.HookEquipmentNodeWrapper;
import de.vw.vaudes.diaghook.dto.HookOdisEcuReferenceWrapper;
import de.vw.vaudes.diaghook.factory.OverlayingFactoryObjectResolver;
import de.vw.vaudes.diaghook.transform.DbgHookTransformHelper;
import de.vw.vaudes.diaghook.util.DiagnosticDataAccessHelper;
import de.vw.vaudes.xml.object.Ausstattungsmerkmal;
import de.vw.vaudes.xml.object.AusstattungsmerkmalDOM;
import de.vw.vaudes.xml.object.ObjektverweisByObjektIdTYPE;
import de.vw.vaudes.xml.object.VAUDESObjekt;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EquipmentObjTransformHelper {
    private static final Log LOG = LogFactory.getLog(EquipmentObjTransformHelper.class);

    private EquipmentObjTransformHelper() {
    }

    public static boolean transformEquipmentObject(IEquipmentNode iEquipmentNode, VAUDESObjekt vAUDESObjekt) {
        boolean bl = false;
        if (null == vAUDESObjekt.getAusstattungsmerkmal()) {
            LOG.warn((Object)"Attempt to transform a non-equipment object to a equipment object");
        } else {
            Ausstattungsmerkmal ausstattungsmerkmal = vAUDESObjekt.getAusstattungsmerkmal();
            iEquipmentNode.setNodeType(EquipmentObjTransformHelper.transformEquipmentType(ausstattungsmerkmal.getTyp()));
            if (null != ausstattungsmerkmal.getHatTraversierungstest()) {
                iEquipmentNode.setTraversionTestKey(ausstattungsmerkmal.getHatTraversierungstest().getVerweis().getObjektRef());
            } else {
                iEquipmentNode.setTraversionTestKey(null);
            }
            iEquipmentNode.setCanDiagnosis(false);
            iEquipmentNode.setKnowledgeBaseKey(null);
            iEquipmentNode.setReadTimeGatewayList(Integer.MIN_VALUE);
            iEquipmentNode.setWaitTimeAfterGatewayCoding(Integer.MIN_VALUE);
            iEquipmentNode.setDiagProjectName(null);
            iEquipmentNode.setDiesel(false);
            iEquipmentNode.setDiagObjectOnComErrorKey(null);
            iEquipmentNode.setWaitTimeAfterBroadcastDTCDelete(Integer.MIN_VALUE);
            iEquipmentNode.setUseBroadcastForDTCDelete(false);
            iEquipmentNode.setWaitTimeAfterIgnition(Integer.MIN_VALUE);
            iEquipmentNode.setWaitTimeAfterDTCDelete(Integer.MIN_VALUE);
            iEquipmentNode.setBrand(null);
            iEquipmentNode.setAlwaysReadDTCs(false);
            iEquipmentNode.setObd2(false);
            iEquipmentNode.setDefinitelyPresent(false);
            iEquipmentNode.setWaitTimeAfterDTCDelete(Integer.MIN_VALUE);
            if (null != ausstattungsmerkmal.getGrundmerkmal()) {
                EquipmentObjTransformHelper.transformBaseAttribute(iEquipmentNode, ausstattungsmerkmal.getGrundmerkmal());
            } else if (null != ausstattungsmerkmal.getSteuergeraeteAusstattung()) {
                iEquipmentNode.setAlwaysReadDTCs(ausstattungsmerkmal.getSteuergeraeteAusstattung().isFspImmerLesen());
                iEquipmentNode.setObd2(ausstattungsmerkmal.getSteuergeraeteAusstattung().isIstOBDII());
                iEquipmentNode.setDefinitelyPresent(EquipmentObjTransformHelper.transformObstructionState(ausstattungsmerkmal.getSteuergeraeteAusstattung().getVerbauung()));
                iEquipmentNode.setWaitTimeAfterDTCDelete(ausstattungsmerkmal.getSteuergeraeteAusstattung().getLoeschenLesenWartezeit().intValue());
                if (null != ausstattungsmerkmal.getSteuergeraeteAusstattung().getSGReferenz()) {
                    iEquipmentNode.setEcuReference((IOdisEcuReference)new HookOdisEcuReferenceWrapper(ausstattungsmerkmal.getSteuergeraeteAusstattung().getSGReferenz()));
                }
            }
            iEquipmentNode.setEquipmentNodeGfsId(vAUDESObjekt.getSystemname());
            iEquipmentNode.setEquipmentNodeKey(vAUDESObjekt.getId());
            if (null != vAUDESObjekt.getAnzeigename()) {
                iEquipmentNode.setName(DbgHookTransformHelper.createTextIdFrom(vAUDESObjekt.getId(), vAUDESObjekt.getAnzeigename().getStringRef()));
            } else {
                iEquipmentNode.setName(null);
            }
            bl = true;
        }
        return bl;
    }

    private static void transformBaseAttribute(IEquipmentNode iEquipmentNode, Ausstattungsmerkmal.Grundmerkmal grundmerkmal) {
        if (null != grundmerkmal.getFahrzeugtyp()) {
            iEquipmentNode.setCanDiagnosis(grundmerkmal.getFahrzeugtyp().isIstCANDiagnose());
            iEquipmentNode.setVinModelCodes(grundmerkmal.getFahrzeugtyp().getFZTvin().toArray(new String[0]));
            if (null != grundmerkmal.getFahrzeugtyp().getHatWissensbasis()) {
                iEquipmentNode.setKnowledgeBaseKey(grundmerkmal.getFahrzeugtyp().getHatWissensbasis().getVerweis().getObjektRef());
            }
            if (null != grundmerkmal.getFahrzeugtyp().getLesezeitSollverbauung()) {
                iEquipmentNode.setReadTimeGatewayList(grundmerkmal.getFahrzeugtyp().getLesezeitSollverbauung().intValue());
            }
            if (null != grundmerkmal.getFahrzeugtyp().getVerzoegerungCodierung()) {
                iEquipmentNode.setWaitTimeAfterGatewayCoding(grundmerkmal.getFahrzeugtyp().getVerzoegerungCodierung().intValue());
            }
            if (null != grundmerkmal.getFahrzeugtyp().getCarportanfrage()) {
                iEquipmentNode.setCarportPreselection(EquipmentObjTransformHelper.getCarportPreselection(grundmerkmal.getFahrzeugtyp().getCarportanfrage()));
            }
            if (null != grundmerkmal.getFahrzeugtyp().isMkbuebersg()) {
                iEquipmentNode.setMkbAvailable(grundmerkmal.getFahrzeugtyp().isMkbuebersg().booleanValue());
            }
            if (null != grundmerkmal.getFahrzeugtyp().getLandessetzung()) {
                iEquipmentNode.setCountryPreselection(grundmerkmal.getFahrzeugtyp().getLandessetzung());
            }
        } else if (null != grundmerkmal.getModelljahr()) {
            iEquipmentNode.setDiagProjectName(grundmerkmal.getModelljahr().getDiagProjektName());
            iEquipmentNode.setCanDiagnosis(grundmerkmal.getModelljahr().isIstCANDiagnose());
            iEquipmentNode.setVinModelYearCode(grundmerkmal.getModelljahr().getMDJvin().get(0));
            if (null != grundmerkmal.getModelljahr().getLesezeitSollverbauung()) {
                iEquipmentNode.setReadTimeGatewayList(grundmerkmal.getModelljahr().getLesezeitSollverbauung().intValue());
            }
            if (null != grundmerkmal.getModelljahr().getVerzoegerungCodierung()) {
                iEquipmentNode.setWaitTimeAfterGatewayCoding(grundmerkmal.getModelljahr().getVerzoegerungCodierung().intValue());
            }
        } else if (null != grundmerkmal.getVariante()) {
            iEquipmentNode.setCanDiagnosis(grundmerkmal.getVariante().isIstCANDiagnose());
            if (null != grundmerkmal.getVariante().getLesezeitSollverbauung()) {
                iEquipmentNode.setReadTimeGatewayList(grundmerkmal.getVariante().getLesezeitSollverbauung().intValue());
            }
            if (null != grundmerkmal.getVariante().getVerzoegerungCodierung()) {
                iEquipmentNode.setWaitTimeAfterGatewayCoding(grundmerkmal.getVariante().getVerzoegerungCodierung().intValue());
            }
            if (null != grundmerkmal.getVariante().getCarportanfrage()) {
                iEquipmentNode.setCarportPreselection(EquipmentObjTransformHelper.getCarportPreselection(grundmerkmal.getVariante().getCarportanfrage()));
            }
            if (null != grundmerkmal.getVariante().isMkbuebersg()) {
                iEquipmentNode.setMkbAvailable(grundmerkmal.getVariante().isMkbuebersg().booleanValue());
            }
        } else if (null != grundmerkmal.getMotorkennbuchstabe()) {
            iEquipmentNode.setCanDiagnosis(grundmerkmal.getMotorkennbuchstabe().isIstCANDiagnose());
            iEquipmentNode.setDiesel(grundmerkmal.getMotorkennbuchstabe().isIstDiesel());
            if (null != grundmerkmal.getMotorkennbuchstabe().getHatDOBeiKommunikationsstoerung()) {
                iEquipmentNode.setDiagObjectOnComErrorKey(grundmerkmal.getMotorkennbuchstabe().getHatDOBeiKommunikationsstoerung().getVerweis().getObjektRef());
            }
            if (null != grundmerkmal.getMotorkennbuchstabe().getWartezeitNachFehlerspeicherLoeschenMitBroadcast()) {
                iEquipmentNode.setWaitTimeAfterBroadcastDTCDelete(grundmerkmal.getMotorkennbuchstabe().getWartezeitNachFehlerspeicherLoeschenMitBroadcast().intValue());
            }
            iEquipmentNode.setUseBroadcastForDTCDelete(grundmerkmal.getMotorkennbuchstabe().isFehlerspeicherLoeschenMitBroadcast());
            if (null != grundmerkmal.getMotorkennbuchstabe().getWartezeitNachZuendungEin()) {
                iEquipmentNode.setWaitTimeAfterIgnition(grundmerkmal.getMotorkennbuchstabe().getWartezeitNachZuendungEin().intValue());
            }
            if (null != grundmerkmal.getMotorkennbuchstabe().getWartezeitNachFehlerspeicherLoeschenMitBroadcast()) {
                iEquipmentNode.setWaitTimeAfterDTCDelete(grundmerkmal.getMotorkennbuchstabe().getWartezeitNachFehlerspeicherLoeschenMitBroadcast().intValue());
            }
            if (null != grundmerkmal.getMotorkennbuchstabe().getCarportanfrage()) {
                iEquipmentNode.setCarportPreselection(EquipmentObjTransformHelper.getCarportPreselection(grundmerkmal.getMotorkennbuchstabe().getCarportanfrage()));
            }
            if (null != grundmerkmal.getMotorkennbuchstabe().isMkbuebersg()) {
                iEquipmentNode.setMkbAvailable(grundmerkmal.getMotorkennbuchstabe().isMkbuebersg().booleanValue());
            }
        } else if (null != grundmerkmal.getMarke()) {
            iEquipmentNode.setBrand(grundmerkmal.getMarke().getNameKVPS());
        }
    }

    private static String[] getCarportPreselection(String string) {
        return StringUtils.split((String)string, (char)'+');
    }

    private static boolean transformObstructionState(String string) {
        return "obligatorisch".equals(string.toLowerCase());
    }

    private static int transformEquipmentType(AusstattungsmerkmalDOM ausstattungsmerkmalDOM) {
        int n = 0;
        if (ausstattungsmerkmalDOM.value().equalsIgnoreCase("Marke")) {
            n = 1;
        } else if (ausstattungsmerkmalDOM.value().equalsIgnoreCase("Fahrzeugtyp")) {
            n = 2;
        } else if (ausstattungsmerkmalDOM.value().equalsIgnoreCase("Modelljahr")) {
            n = 3;
        } else if (ausstattungsmerkmalDOM.value().equalsIgnoreCase("Variante")) {
            n = 4;
        } else if (ausstattungsmerkmalDOM.value().equalsIgnoreCase("Motor")) {
            n = 5;
        } else if (ausstattungsmerkmalDOM.value().equalsIgnoreCase("EXOR")) {
            n = 7;
        } else if (ausstattungsmerkmalDOM.value().equalsIgnoreCase("SteuergeraeteAusstattung")) {
            n = 8;
        } else if (ausstattungsmerkmalDOM.value().equalsIgnoreCase("AusstattungOhneDiagnoseSchnittstelle")) {
            n = 9;
        }
        return n;
    }

    public static IEquipmentNode createEquipmentObjectFrom(VAUDESObjekt vAUDESObjekt) {
        HookEquipmentNodeWrapper hookEquipmentNodeWrapper = null;
        HookEquipmentNodeWrapper hookEquipmentNodeWrapper2 = new HookEquipmentNodeWrapper();
        if (EquipmentObjTransformHelper.transformEquipmentObject(hookEquipmentNodeWrapper2, vAUDESObjekt)) {
            hookEquipmentNodeWrapper = hookEquipmentNodeWrapper2;
        }
        return hookEquipmentNodeWrapper;
    }

    public static List<IEquipmentNode> getEquipmentNodeChildrenFrom(VAUDESObjekt vAUDESObjekt) throws NonUniqueResultException {
        ArrayList<IEquipmentNode> arrayList = new ArrayList<IEquipmentNode>();
        if (null == vAUDESObjekt.getAusstattungsmerkmal()) {
            LOG.warn((Object)"Attempt to transform a non-equipment object to a equipment object");
            return arrayList;
        }
        if (null == vAUDESObjekt.getAusstattungsmerkmal().getHatAusstattungsmerkmale()) {
            return arrayList;
        }
        for (ObjektverweisByObjektIdTYPE objektverweisByObjektIdTYPE : vAUDESObjekt.getAusstattungsmerkmal().getHatAusstattungsmerkmale().getVerweis()) {
            try {
                VAUDESObjekt vAUDESObjekt2;
                Object object = DiagnosticDataAccessHelper.parseFile(objektverweisByObjektIdTYPE.getObjektRef(), VAUDESObjekt.class);
                if (!(object instanceof VAUDESObjekt)) {
                    LOG.warn((Object)("Referenced equipment object not found in index: " + objektverweisByObjektIdTYPE.getObjektRef()));
                    vAUDESObjekt2 = OverlayingFactoryObjectResolver.getInstance().getEquipmentNode(objektverweisByObjektIdTYPE.getObjektRef());
                    if (null == vAUDESObjekt2) continue;
                    arrayList.add((IEquipmentNode)vAUDESObjekt2);
                    continue;
                }
                vAUDESObjekt2 = (VAUDESObjekt)object;
                arrayList.add(EquipmentObjTransformHelper.createEquipmentObjectFrom(vAUDESObjekt2));
            }
            catch (Exception exception) {
                LOG.error((Object)("Error while parsing object with id " + objektverweisByObjektIdTYPE), (Throwable)exception);
            }
        }
        return arrayList;
    }
}

