<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">

	<!-- *************************************************** Versionierung und Änderungsverfolgung ***************************************************************** -->
	<!-- %version: 8 %  (for a complete list use Synergy/CCM)                                                                     -->

	<xsl:template name="T_Vaudas_diag_prot_css">
		<!-- Choose the orientation and the alignment to be used in all styles-->
		<xsl:variable name="textOrientation">
			<xsl:choose>
    			<xsl:when test="information/is_right_to_left = 'true'">rtl</xsl:when>
    			<xsl:otherwise>ltr</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="textAlignment">
			<xsl:choose>
    			<xsl:when test="information/is_right_to_left = 'true'">right</xsl:when>
    			<xsl:otherwise>left</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="textAlignmentOpposite">
			<xsl:choose>
    			<xsl:when test="information/is_right_to_left = 'true'">left</xsl:when>
    			<xsl:otherwise>right</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
	
		<style type="text/css">
			table {border-width:0;border-collapse:collapse;padding:0;margin:0;width:800px}
			tr, td {border-width:0;padding:0;margin:0;text-align:<xsl:value-of select="$textAlignment"/>}
			tr:hover {background-color: #dcdcdc}
			td {width:60mm;vertical-align:center}
			.align_opposite {text-align:<xsl:value-of select="$textAlignmentOpposite"/>;}
			
			span {margin-top:0pt;margin-bottom:0pt}
			p, .p_mini {margin-top:0pt;margin-bottom:0pt}
			.p_word-wrap {word-wrap: break-word; word-break: break-all}
			.p_small {margin-top:10pt;margin-bottom:10pt}
			.p_big {margin-top:16pt;margin-bottom:16pt}
			.courier_style {margin-top:0;margin-bottom:0;font-size:10pt;font-family:"Courier New";direction:<xsl:value-of select="$textOrientation"/>}
			
			#button_bar span button span,
			.default_style, .default_style_b, .default_style_r, .default_style_bi, .default_style_i, .default_style_bu, .default_style_u, .header_style_small, .small_style {margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;direction:<xsl:value-of select="$textOrientation"/>}
			.default_style_r{color:#FF0000}
			
			thead th, thead td {margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;direction:<xsl:value-of select="$textOrientation"/>;font-weight:bold;text-align:<xsl:value-of select="$textAlignment"/>;}
						
			.default_style_b, .header_style_middle, .header_style_big, .header_style_middle_b_12 {font-weight:bold}
			.default_style_bi, .default_style_big_bi {font-weight:bold;font-style:italic}
			.default_style_i {font-style:italic}
			.default_style_bu, .header_style_middle_bu, .default_style_bu_r, .small_style_bu, .header_style_middle_bu_12 {font-weight:bold;text-decoration:underline}
			.default_style_bu_r {color:#FF0000}
			.default_style_u {text-decoration:underline}
			.default_style_big_bi {font-size:24pt}
			.header_style_big {font-size:24pt}
			
			.header_style_middle_bu {font-size:16pt}
			.header_style_middle_bu_12, .header_style_middle_b_12 {font-size:12pt}
			.header_style_middle {font-size:16pt}
			.header_style_small, .header_style_date {font-size:11pt}
			.header_style_date {font-weight:bold}
			.small_style, .very_small_style, .small_style_b {font-size:8pt}
			.very_small_style {font-size:6pt}
			.small_style_b {font-weight:bold}
			.small_style_bu {font-size:8pt}
			.general_information_type_title {font-weight:bold}
			
			.eventmemory_subheadline, .eventmemory_subsubheadline, .eventmemory_subsubsubheadline {margin-top:12pt;margin-bottom:3pt;font-size:10pt;font-family:Arial;font-weight:bold;direction:<xsl:value-of select="$textOrientation"/>}
			.eventmemory_subsubheadline {margin-top:9pt;margin-bottom:0pt}
			.eventmemory_subsubsubheadline {margin-top:6pt;margin-bottom:0pt}
			
			.number_plus_link_symbol_for_functiontest {vertical-align:super; font-size:80%;}
			.number_plus_link_symbol_for_functiontest:before {content:'↳'; vertical-align:bottom; font-size:125%; font-weight:bold;}
			@media print {
				.href_top {display:none;}
			}

			.unit_spacer {padding-<xsl:value-of select="$textAlignment"/>:0.167em;} 
			.result_padding {padding-<xsl:value-of select="$textAlignment"/>:2em; padding-<xsl:value-of select="$textAlignmentOpposite"/>:0.5em;}
			.user_input {margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;direction:<xsl:value-of select="$textOrientation"/>;color:#006400;font-weight:bold;}
			
			.font_arial {font-family:Arial}
			.font_courier {font-family:"Courier New"}
			.font_sidis {font-family:SidisSymbole}
			.font_symbol {font-family:"Symbol"}
			.font_wingdings {font-family:"Wingdings"}
			.size_small {font-size:10pt}
			.size_big {font-size:12pt}
			.color_black {color:#000000}
			.color_red {color:#FF0000}
			.color_green {color:#006400}
			.color_blue {color:#0000FF}
			.color_yellow {color:#FFF405}
			.color_green2 {color:#92C027}
			.color_blue2 {color:#6BBCE4}
			.style_normal {font-style:normal}
			.style_italic {font-style:italic}
			.weight_normal {font-weight:normal}
			.weight_bold {font-weight:bold}

			.treeView_header {position:relative;} 
			
			input.treeView {float:<xsl:value-of select="$textAlignment"/> !important; z-index:-1 !important; position:absolute; vertical-align:middle;  width:0px; height:0px; overflow:hidden;}
			
			label.treeView.hover {text-decoration:underline; vertical-align:middle;}
			label.treeView {cursor:pointer; vertical-align:middle;}
			.treeView_label_content { position:relative; <xsl:value-of select="$textAlignment"/>:1.5em; vertical-align:middle;}
			.treeView_selector_item { position:absolute; display:table-cell; vertical-align:middle; border:1px solid; padding-<xsl:value-of select="$textAlignment"/>:0.33em; padding-<xsl:value-of select="$textAlignmentOpposite"/>:0.33em; background-color:#E7E7E7; font-family:Consolas,'Courier New',Courier; margin-top:0;margin-bottom:0;font-size:10pt;font-weight:bold;direction:<xsl:value-of select="$textOrientation"/>}
			
			<xsl:choose>
				<xsl:when test="$V_expand_tree_views = 'false'">
			.treeView_content {clear:<xsl:value-of select="$textAlignment"/>; margin-<xsl:value-of select="$textAlignment"/>:2%; width:98%; background-color:#ffffff; display:none}
				</xsl:when>
				<xsl:otherwise>
			.treeView_content {clear:<xsl:value-of select="$textAlignment"/>; margin-<xsl:value-of select="$textAlignment"/>:2%; width:98%; background-color:#ffffff; display:block}
				</xsl:otherwise>
			</xsl:choose>
			@media print {
				.treeView_selector_item,
				input.treeView { display:none; }
				.treeView_label_content { position:static; }
				.hidden_in_print_protocol { display:none;  }
			}
			@media aural, braille, embossed, handheld, projection, screen, tty, tv {
				.hidden_in_html_protocol { display:none;  }
			}

			#button_bar {position:fixed; <xsl:value-of select="$textAlignmentOpposite"/>:15px; text-align:<xsl:value-of select="$textAlignment"/>;}
			#button_bar span {display:block;}
			@media print {
				#button_bar {display:none;}
			}
			
			.table_spec {border-width:0px;border-style:solid;border-collapse:collapse;padding:0;margin:0;width:165mm;table-layout:auto;}
			.table_spec tr {vertical-align:top;}
		</style>
	</xsl:template>
</xsl:stylesheet>
