<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- *************************************************** Versionsvariablen *************** -->
	<!-- %version: 6 %  (for a complete list use Synergy/CCM)                                  -->
	<!-- *************************************************** Versionsvariablen *************** -->
	<xsl:variable name="V_Stylesheet_Version_function_templates" select="'1.1'"/>
	<xsl:variable name="V_Stylesheet_Datum_function_templates" select="'12.08.2016'"/>
	
	<!-- *** Functions for creating JavaScript tree views. *** -->
	<!-- To create a treeView do the following steps:
	       1. Insert the start mark with "func_treeView_mark_start" to mark the position where the treeView scripts start searching for content to hide/show.
	          Param "id" (optional): Give an id if you do not want to use the current node.
	       2. Insert the label at any position after the start mark with "func_treeView_label"
	          Param "id" (optional): Must be the same id as for the start mark (see 1.)
	          Param "label" (required): A label that can be clicked by the user to trigger the hide/show functionality. The label may contain formating instructions but avoid line breaking instructions like "<p class="">"; use "<span class="">" instead.
	       3. Annotate any element after the start mark as "hide/show content" by adding the CSS class "treeView_content".
	          (Please note: The scanner will stop when reaching the end tag of the start mark's parent node.)
	       4. Insert (optional) a stop mark with "func_treeView_stop" at the same level as the start mark to help the scanner find the end (this may help avoid performance problems).
	     The treeViews may be cascaded as the scanner will immediately jump back to the parent node of the current position if running on a new start mark. (As a matter of fact: The same applies for stop marks.)-->
	<xsl:template name="func_treeView_mark_start">
		<xsl:param name="id" select="generate-id(.)" />
		<input type="hidden" class="treeView" name="treeView_parse_start" id="start_marker_treeView_{translate($id, '&#x20;&#x9;&#xD;&#xA;', '')}" /> 
	</xsl:template>
	
	<xsl:template name="func_treeView_label">
		<xsl:param name="id" select="generate-id(.)" />
		<xsl:param name="label" select="'Lorem Ipsum (tree node head)'" />
		<span class="treeView_header">
			<xsl:choose>
				<xsl:when test="$V_expand_tree_views = 'false'">
					<input type="checkbox" name="treeView_checkbox" onChange="javascript:showHideSectionsAfterCheckbox(this)" onClick="javascript:showHideSectionsAfterCheckbox(this)" class="treeView" id="treeView_{translate($id, '&#x20;&#x9;&#xD;&#xA;', '')}" />
				<label for="treeView_{translate($id, '&#x20;&#x9;&#xD;&#xA;', '')}" id="label_{translate($id, '&#x20;&#x9;&#xD;&#xA;', '')}" class="treeView"><span class="treeView_selector_item">+</span><span class="treeView_label_content"><xsl:copy-of select="$label" /></span></label>
				</xsl:when>
				<xsl:otherwise>
					<input type="checkbox" name="treeView_checkbox" onChange="javascript:showHideSectionsAfterCheckbox(this)" onClick="javascript:showHideSectionsAfterCheckbox(this)" class="treeView" id="treeView_{translate($id, '&#x20;&#x9;&#xD;&#xA;', '')}" checked="checked" />
					<label for="treeView_{translate($id, '&#x20;&#x9;&#xD;&#xA;', '')}" id="label_{translate($id, '&#x20;&#x9;&#xD;&#xA;', '')}" class="treeView"><span class="treeView_selector_item">-</span><span class="treeView_label_content"><xsl:copy-of select="$label" /></span></label>
				</xsl:otherwise>
			</xsl:choose>
		</span>
	</xsl:template>
	
	<xsl:template name="func_treeView_stop">
		<input type="hidden" class="treeView" name="treeView_parse_stop" />
	</xsl:template>
	
	<!-- Call this function to create a link to a defined treeView label (see func_treeView_label)
	     Param "id" the same id used for func_treeView_label
	     Param "link" the section that shall be clickable as link to the label -->
	<xsl:template name="func_hyperref_label">
		<xsl:param name="id" select="generate-id(.)" />
		<xsl:param name="link" >&lt;&lt;<xsl:value-of select="$Text_href_functiontest_top"/>&gt;&gt;</xsl:param>
		<a class="href_top" href="#label_{translate($id, '&#x20;&#x9;&#xD;&#xA;', '')}" onclick="javascript:showSectionsByID('{translate($id, '&#x20;&#x9;&#xD;&#xA;', '')}')"><xsl:copy-of select="$link" /></a>
	</xsl:template>
</xsl:stylesheet>