<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="function_templates.xsl"/>
	<!-- *************************************************** Versionierung und Aenderungsverfolgung *****************************************************************-->
	<!-- %version: 50 %  (for a complete list use Synergy/CCM)                                                                     -->
	<!-- @version $Id: 8ff67de4f5d685f28950f9fe6ba06ff3ff1aada4 $ -->
	<!-- 30.11.2022 V1.62: CCB1049: add measurement_protocol_entries for module balancer methods -->
	<!--            V1.62: QCID 22714: Bugfix cancel testprogram display only in root -->
	<!-- 08.01.2025 V1.63: CCB3100: Replace function_warranty_void_time with function_exclude_net_test_time -->
	<!-- *************************************************** Versionsvariablen *************** -->
	<xsl:variable name="V_Stylesheet_Version_functiontests" select="'1.62'"/>
	<xsl:variable name="V_Stylesheet_Datum_functiontests" select="'30.11.2022'"/>
	<!-- **************************************************************************************************************************** -->
	<!-- template T_functiontests-->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_functiontests">
		<p class="header_style_middle_bu">
			<xsl:value-of select="$Text_functiontests"/></p>
		<xsl:if test="count(guided_fault_finding/diagnosis_log/function_test)=0">
			<p>
				<xsl:value-of select="$Text_no_functiontests"/></p>
		</xsl:if>
		<xsl:for-each select="guided_fault_finding/diagnosis_log/function_test">
			<xsl:call-template name="T_functiontest"/>
		</xsl:for-each>
	</xsl:template>
	<!-- **************************************************************************************************************************** -->
	<!-- template T_last_functiontest-->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_last_functiontest">
		<p class="header_style_middle_bu">
			<xsl:value-of select="$Text_last_functiontest"/></p>
		<xsl:for-each select="guided_fault_finding/diagnosis_log/function_test[last()]">
			<xsl:call-template name="T_functiontest"/>
		</xsl:for-each>
	</xsl:template>
	<!-- **************************************************************************************************************************** -->
	<!-- template T_functiontest-->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_functiontest">
		<p class="p_small"/>
		<!-- headline -->
		<xsl:call-template name="func_treeView_mark_start" />
		<p class="default_style_b">
			<xsl:call-template name="func_treeView_label">
				<xsl:with-param name="label"><span class="header_style_middle_bu_12"><xsl:value-of select="$Text_functiontest"/>&#160;<xsl:value-of select="./function_test_number"/>:&#160;<xsl:value-of select="./function_test_id"/></span></xsl:with-param>
			</xsl:call-template></p>
		<p class="header_style_middle_b_12"><xsl:value-of select="./function_test_title"/></p>
		<xsl:call-template name="T_general_information"/>
		<span class="treeView_content">
			<xsl:choose>
				<xsl:when test="test_step/test_step_content/function_call/test_step">
					<xsl:call-template name="T2_teststeps"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="T_teststeps"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:call-template name="T_local_variables"/>
			<xsl:call-template name="T_general_information">
				<xsl:with-param name="end_of_test" select="true()"/>
			</xsl:call-template>
		</span>
		<xsl:call-template name="func_treeView_stop"/>
	</xsl:template>
	<!-- **************************************************************************************************************************** -->
	<!-- template T_backgroundtests-->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_backgroundtests">
		<p class="header_style_middle_bu">
			<xsl:value-of select="$Text_backgroundtests"/></p>
		<xsl:if test="count(guided_fault_finding/diagnosis_log/background_test)=0">
			<p>
				<xsl:value-of select="$Text_no_backgroundtests"/></p>
		</xsl:if>
		<xsl:for-each select="guided_fault_finding/diagnosis_log/background_test">
			<xsl:call-template name="T_backgroundtest"/>
		</xsl:for-each>
	</xsl:template>
	<!-- **************************************************************************************************************************** -->
	<!-- template T_backgroundtest-->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_backgroundtest">
		<p class="p_small"/>
		<!-- headline -->
		<xsl:call-template name="func_treeView_mark_start" />
		<p class="default_style_b">
			<xsl:call-template name="func_treeView_label">
				<xsl:with-param name="label"><span class="header_style_middle_bu_12"><xsl:value-of select="$Text_backgroundtest"/>&#160;<xsl:value-of select="./function_test_number"/>:&#160;<xsl:value-of select="./function_test_id"/></span></xsl:with-param>
			</xsl:call-template></p>
		<p class="header_style_middle_b_12"><xsl:value-of select="./function_test_title"/></p>
		<xsl:call-template name="T_general_information"/>
		<span class="treeView_content">
			<xsl:choose>
				<xsl:when test="test_step/test_step_content/function_call/test_step">
					<xsl:call-template name="T2_teststeps"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="T_teststeps"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:call-template name="T_local_variables"/>
			<xsl:call-template name="T_general_information">
				<xsl:with-param name="end_of_test" select="true()"/>
			</xsl:call-template>
		</span>
		<xsl:call-template name="func_treeView_stop"/>
	</xsl:template>
	<!-- **************************************************************************************************************************** -->
	<!-- template T_general_information-->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_general_information">
		<xsl:param name="end_of_test" select="false()" />
		<xsl:param name="indentLevel" select="0" />
		<xsl:param name="hyperrefId" select="generate-id(.)" />
		<table>
			<tr>
				<td>
					<br>
						<xsl:choose>
							<xsl:when test="self::function_return">
								<xsl:value-of select="$Text_teststep_content_function_return_result"/>:
								<span class="result_padding"><xsl:value-of select="result"/></span>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$Text_functiontest_result"/>:<span class="result_padding"><xsl:value-of select="./function_test_result"/></span>
							</xsl:otherwise>
						</xsl:choose></br>
				</td>
				<td class="align_opposite">
					<xsl:if test="$end_of_test">
						<xsl:call-template name="func_hyperref_label">
							<xsl:with-param name="id" select="$hyperrefId"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="not($end_of_test)">
						<p class="very_small_style">
							<xsl:value-of select="$Text_session_time_spent"/>:&#160;<xsl:value-of disable-output-escaping="yes" select="format-number(./function_test_time_spent,'0.0')"/></p>
					    <xsl:if test="start_time">
					    	<p class="very_small_style">
					    		<xsl:call-template name="T_dateTime"><xsl:with-param name="dateTime" select="./start_time"/></xsl:call-template>
					    		<xsl:text> - </xsl:text>
					    		<xsl:call-template name="T_dateTime"><xsl:with-param name="dateTime" select="./finish_time"/></xsl:call-template>
					    	</p>
					    </xsl:if>
						<!-- Add statistic data (click and key count, not for engineering) -->
						<xsl:if test="not(contains(version/Vaudas/name, 'ngineering'))">
							<p class="very_small_style">
								<xsl:value-of select="$Text_session_program_mouse_click_count"/>:&#160;<xsl:value-of disable-output-escaping="yes" select="./function_mouse_clicks_occurred"/></p>
							<p class="very_small_style">
								<xsl:value-of select="$Text_session_program_key_pressed_count"/>:&#160;<xsl:value-of disable-output-escaping="yes" select="./function_key_pressed_occurred"/></p>
							<xsl:if test="./function_exclude_test_time = 'true'">
								<p class="very_small_style"><xsl:value-of select="$Text_session_program_exclude_test_time"/></p>
							</xsl:if>
							<xsl:if test="./function_exclude_net_test_time = 'true'">
								<p class="very_small_style"><xsl:value-of select="$Text_functiontest_warranty_net_void"/></p>
							</xsl:if>
						</xsl:if>
						<p class="very_small_style">
							<xsl:value-of select="$Text_workshop_vci_connection_type"/>:&#160;<xsl:value-of disable-output-escaping="yes" select="./function_connection_type_used"/></p>
						<p class="very_small_style">
							<xsl:value-of select="$Text_workshop_communication_type"/>:&#160;<xsl:value-of disable-output-escaping="yes" select="./function_communication_type_used"/></p>
						<!-- Add statistic data (displayed dialogs before and after the execution) -->
						<xsl:if test="./function_pre_post_execution_dialogs and ./function_pre_post_execution_dialogs != ''">
							<p class="very_small_style">
								<xsl:value-of select="$Text_dialog_message"/>:&#160;<xsl:value-of select="./function_pre_post_execution_dialogs"/>
							</p>
						</xsl:if>
					</xsl:if>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- **************************************************************************************************************************** -->
	<!-- template T_dateTime -->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_dateTime">
		<xsl:param name="dateTime" select="./start_time" />
		<xsl:if test="$dateTime/date">
			<xsl:call-template name="T_twoDigits">
				<xsl:with-param name="s">
					<xsl:value-of select="$dateTime/date/day" />
				</xsl:with-param>
			</xsl:call-template>
			<xsl:text>.</xsl:text>			
			<xsl:call-template name="T_twoDigits">
				<xsl:with-param name="s">
					<xsl:value-of select="$dateTime/date/month" />
				</xsl:with-param>
			</xsl:call-template>
			<xsl:text>.</xsl:text>			
			<xsl:call-template name="T_twoDigits">
				<xsl:with-param name="s">
					<xsl:value-of select="$dateTime/date/year" />
				</xsl:with-param>
			</xsl:call-template>
			<xsl:text> </xsl:text>			
		</xsl:if>
		<xsl:if test="$dateTime/time">
			<xsl:call-template name="T_twoDigits">
				<xsl:with-param name="s">
					<xsl:value-of select="$dateTime/time/hours"/>
				</xsl:with-param>
			</xsl:call-template>
			<xsl:text>:</xsl:text>
			<xsl:call-template name="T_twoDigits">
				<xsl:with-param name="s">
					<xsl:value-of select="$dateTime/time/minutes"/>
				</xsl:with-param>
			</xsl:call-template>
			<xsl:text>:</xsl:text>
			<xsl:call-template name="T_twoDigits">
				<xsl:with-param name="s">
					<xsl:value-of select="$dateTime/time/seconds"/>
				</xsl:with-param>
			</xsl:call-template>
			<xsl:if test="$dateTime/time/millis">
				<xsl:text>,</xsl:text>
				<xsl:call-template name="T_threeDigits">
					<xsl:with-param name="s">
						<xsl:value-of select="$dateTime/time/millis"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<!-- **************************************************************************************************************************** -->
	<!-- template T_twoDigits: fill with leading zeros -->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_twoDigits">
		<xsl:param name="s" />
		<xsl:choose>
			<xsl:when test="string-length($s) &gt; 1">
				<xsl:value-of select="$s"/>
			</xsl:when>
			<xsl:otherwise><xsl:text>0</xsl:text><xsl:value-of select="$s"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- **************************************************************************************************************************** -->
	<!-- template T_threeDigits: append missing zeros -->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_threeDigits">
		<xsl:param name="s" />
		<xsl:param name="slen" select="string-length($s)" />
		<xsl:choose>
			<xsl:when test="slen &gt; 2">
				<xsl:value-of select="$s"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="$slen = 0"><xsl:text>000</xsl:text></xsl:if>
				<xsl:if test="$slen = 1"><xsl:text>00</xsl:text></xsl:if>
				<xsl:if test="$slen = 2"><xsl:text>0</xsl:text></xsl:if>
				<xsl:value-of select="$s"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- **************************************************************************************************************************** -->
	<!-- template T_teststeps-->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_teststeps">
		<xsl:param name="nodeset" select="child::test_step" />
		<xsl:param name="indentLevel" select="0" />
		<xsl:param name="returnNodeId" select="$nodeset[last()]/@runtime_id"/>
		<!-- Todo Stopp-Marker definieren, so dass bei Unteraufrufen nicht ewig weiter geparst wird, sondern nur bis zum passenden Marker (große Aufgabe?!) -->
		<xsl:for-each select="$nodeset[1]">
			<p class="p_small"/>
			<!-- headline -->
			<xsl:call-template name="func_treeView_mark_start">
				<xsl:with-param name="id">Teststep_<xsl:value-of select="generate-id(.)" /></xsl:with-param>
			</xsl:call-template>
<!--			<xsl:message>Called from <xsl:value-of select="./@runtime_id"/> to <xsl:value-of select="$returnNodeId"/> (@<xsl:value-of select="$indentLevel" />)</xsl:message> -->
			<xsl:if test="not(./test_step_content/function_return)">
				<table>
					<tr>
						<xsl:choose>
							<xsl:when test="count(./test_step_content)> 0">
								<td style="width:auto">
									<xsl:call-template name="func_treeView_label">
										<xsl:with-param name="id">Teststep_<xsl:value-of select="generate-id(.)" /></xsl:with-param>		
										<xsl:with-param name="label">
											<p class="default_style_bu">
											<!--  style="margin-left:{10+($indentLevel*$indentOffset)}mm" -->
												<xsl:choose>
													<xsl:when test="./test_step_content/function_call">
														<xsl:value-of select="$Text_teststep_content_function_call"/>:&#160;<xsl:value-of select="./test_step_content/function_call/@test_id"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="$Text_teststep"/>:&#160;<xsl:value-of disable-output-escaping="yes" select="./id"/>
													</xsl:otherwise>
												</xsl:choose></p>
										</xsl:with-param>
									</xsl:call-template>
								</td>	
							</xsl:when>	
							<xsl:otherwise>
								<td style="width:auto">
									<p class="default_style_bu">
										<xsl:value-of select="$Text_teststep"/>:&#160;<xsl:value-of disable-output-escaping="yes" select="./id"/></p>
								</td>
							</xsl:otherwise>
						</xsl:choose>
													
						<!-- ZE for test-steps not currently required
						<td style="width:140mm">
							<p class="default_style_sr">
								<xsl:value-of select="$Text_session_time_spent"/>:&#160;&#160;<xsl:value-of disable-output-escaping="yes" select="format-number(./test_step_time_spent,'0.0000')"/>
							</p>
						</td>-->
					</tr>
				</table>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="./test_step_content/function_call">
					<xsl:variable name="localReturnNodeId">
						<xsl:call-template name="T_find_function_return" />
					</xsl:variable>
					<xsl:variable name="localReturnNode" select="following-sibling::test_step[@runtime_id = $localReturnNodeId and test_step_content/function_return/@test_id = $nodeset[1]/test_step_content/function_call/@test_id][1]"/>
					<xsl:variable name="nextNodeSet" select="$localReturnNode/following-sibling::test_step" />
					<span class="treeView_content" id="content_{generate-id(.)}">
						<!-- Find "closing" function return node: -->
						<xsl:call-template name="T_function_call_and_return">
							<xsl:with-param name="nodeset" select="$nodeset" />
							<xsl:with-param name="indentLevel" select="$indentLevel" />
							<xsl:with-param name="returnNodeId" select="$localReturnNodeId" />
						</xsl:call-template>
					</span>
					<xsl:call-template name="func_treeView_stop" />
					<!-- <xsl:message>Next range after function call: <xsl:value-of select="$nextNodeSet[1]/@runtime_id" /> to <xsl:value-of select="($nextNodeSet/following-sibling::test_step[test_step_content/function_return] | $nextNodeSet[last()])[1]/@runtime_id" /></xsl:message> -->
					<xsl:call-template name="T_teststeps">
						<xsl:with-param name="nodeset" select="$nextNodeSet"/>
						<xsl:with-param name="indentLevel" select="$indentLevel" />
						<xsl:with-param name="returnNodeId" select="($nextNodeSet/self::test_step[test_step_content/function_return] | $nextNodeSet/following-sibling::test_step[test_step_content/function_return] | $nextNodeSet[last()])[1]/@runtime_id"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<span class="treeView_content">
						<xsl:call-template name="T_teststep_content">
							<xsl:with-param name="indentLevel" select="$indentLevel"/>
						</xsl:call-template>
					</span>
					<xsl:call-template name="func_treeView_stop" />
				</xsl:otherwise>
			</xsl:choose>
			<xsl:if test="not(./test_step_content/function_call) and not($nodeset[1]/@runtime_id = $returnNodeId)">
				<xsl:call-template name="T_teststeps">
					<xsl:with-param name="nodeset" select="following-sibling::test_step" />
					<xsl:with-param name="indentLevel" select="$indentLevel" />
					<xsl:with-param name="returnNodeId" select="$returnNodeId"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	
	<!-- TODO Implement fix for double "runtime_id" at function_return by creating parameter that holds the function test name as additional condition for checking for the correct match. -->
	
	<!-- **************************************************************************************************************************** -->
	<!-- template T_function_call_and_return-->
	<!-- Outputs formating for a function call and its corresponding function return and calls the T_teststeps template for all test steps between the call and the return. -->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_function_call_and_return">
		<xsl:param name="nodeset" select="self::test_step | following-sibling::test_step" />
		<xsl:param name="indentLevel" select="0" />
		<xsl:param name="returnNodeId">
			<xsl:call-template name="T_find_function_return">
				<xsl:with-param name="nodeset" select="$nodeset" />
			</xsl:call-template>
		</xsl:param>
		<xsl:variable name="returnNode" select="following-sibling::test_step[@runtime_id = $returnNodeId][1]"/>
		<xsl:for-each select="$nodeset[1]/test_step_content">
			<xsl:call-template name="T_function_call">
				<xsl:with-param name="indentLevel" select="$indentLevel" />
			</xsl:call-template>
			<xsl:call-template name="T_teststeps">
				<xsl:with-param name="indentLevel" select="$indentLevel+1"/>
				<xsl:with-param name="nodeset" select="$nodeset[1]/following-sibling::test_step"/>
				<xsl:with-param name="returnNodeId" select="$returnNode/preceding-sibling::test_step[1]/@runtime_id"/>
			</xsl:call-template>
		</xsl:for-each>
		<xsl:for-each select="$nodeset[@runtime_id = $returnNodeId and test_step_content/function_return/@test_id = $nodeset[1]/test_step_content/function_call/@test_id]/test_step_content">
			<p class="p_small"/>
			<!-- Print function return headline label -->
			<table>
				<tr>
					<td style="width:auto">
						<p class="default_style_bu">
							<xsl:value-of select="$Text_teststep_content_function_return"/>:&#160;<xsl:value-of select="function_return/@test_id"/>
						</p>
					</td>
				</tr>
			</table>
			<!-- Print function return content -->
			<xsl:call-template name="T_function_return">
				<xsl:with-param name="indentLevel" select="$indentLevel"/>
				<xsl:with-param name="returnNodeId" select="$returnNodeId"/>
				<xsl:with-param name="hyperrefId">Teststep_<xsl:value-of select="generate-id($nodeset[1])" /></xsl:with-param>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>
		
	<!-- **************************************************************************************************************************** -->
	<!-- template T_find_function_return-->
	<!-- Finds the corresponding (in context of a function call) test_step node that is a function_return. It returns the value of the attribute runtime_id -->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_find_function_return">
		<!-- The set of test_steps that shall be examined starting with the test_step that is the function_call for which a function_return is searched. -->	
		<xsl:param name="nodeset" select="self::test_step | following-sibling::test_step" />
		<!-- The level of cascaded function calls (must be 0 when calling / used for recursive depth control) -->
		<xsl:param name="level" select="0" />
		<!-- Find the next function return or function call -->
 		<xsl:variable name="nextElement" select="($nodeset[1]/following-sibling::test_step[test_step_content/function_call or test_step_content/function_return])[1]" />
 		<xsl:choose>
			<!-- Found a function call that is one level deeper -->
 			<xsl:when test="$nextElement/test_step_content/function_call">
				<xsl:call-template name="T_find_function_return">
					<xsl:with-param name="nodeset" select="$nextElement | $nextElement/following-sibling::test_step"/>
					<xsl:with-param name="level" select="$level + 1" />
				</xsl:call-template>
			</xsl:when>
			<!-- Found a function return -->
			<xsl:otherwise>
				<xsl:choose>
					<!-- The function return is the corresponding part of the function call -->
					<xsl:when test="$level = 0">
						<xsl:value-of select="$nextElement/@runtime_id" />
					</xsl:when>
					<!--  The function return is at least one level too deep to be matching -->
					<xsl:otherwise>
						<xsl:call-template name="T_find_function_return">
							<xsl:with-param name="nodeset" select="$nextElement | $nextElement/following-sibling::test_step"/>
							<xsl:with-param name="level" select="$level - 1" />
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- **************************************************************************************************************************** -->
	<!-- template T_teststep_content-->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_teststep_content">
		<xsl:param name="indentLevel" select="0" />
		<xsl:for-each select="test_step_content">
			<xsl:call-template name="T_action">
				<xsl:with-param name="indentLevel" select="$indentLevel" />
			</xsl:call-template>
 			<xsl:call-template name="T_cancel">
				<xsl:with-param name="indentLevel" select="$indentLevel" />
			</xsl:call-template>
 			<xsl:call-template name="T_measurement_protocol_entries">
				<xsl:with-param name="indentLevel" select="$indentLevel" />
			</xsl:call-template>
            <xsl:call-template name="T_messwert_lesen_table">
            	<xsl:with-param name="indentLevel" select="$indentLevel" />
            </xsl:call-template>
            <xsl:call-template name="T_standard_measurement">
            	<xsl:with-param name="indentLevel" select="$indentLevel" />
            </xsl:call-template>
            <xsl:call-template name="T_identifikationsdaten_auslesen">
            	<xsl:with-param name="indentLevel" select="$indentLevel" />
            </xsl:call-template>
<!--
			<xsl:call-template name="T_function_call">
				<xsl:with-param name="indentLevel" select="$indentLevel" />
			</xsl:call-template>
			<xsl:call-template name="T_function_return">
				<xsl:with-param name="indentLevel" select="$indentLevel" />
			</xsl:call-template>
-->
            <xsl:call-template name="T_ecukom">
            	<xsl:with-param name="indentLevel" select="$indentLevel" />
            </xsl:call-template>
		</xsl:for-each>
	</xsl:template>
	<!-- **************************************************************************************************************************** -->
	<!-- template T2_teststeps for hierarchical traversion -->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T2_teststeps">
		<xsl:param name="indentLevel" select="0" />
		<xsl:param name="nodeset" select="child::test_step" />

		<xsl:for-each select="$nodeset">
			<p class="p_small"/>
			<!-- headline -->
			<xsl:call-template name="func_treeView_mark_start">
				<xsl:with-param name="id">Teststep_<xsl:value-of select="generate-id(.)" /></xsl:with-param>
			</xsl:call-template>
			<!-- <xsl:message>Called from <xsl:value-of select="./@runtime_id"/> @<xsl:value-of select="$indentLevel" />)</xsl:message>  -->
			<xsl:if test="not(./test_step_content/function_return)">
				<table>
					<tr>
						<xsl:choose>
							<xsl:when test="count(./test_step_content)> 0">
								<td style="width:auto">
									<xsl:call-template name="func_treeView_label">
										<xsl:with-param name="id">Teststep_<xsl:value-of select="generate-id(.)" /></xsl:with-param>		
										<xsl:with-param name="label">
											<p class="default_style_bu">
											<!--  style="margin-left:{10+($indentLevel*$indentOffset)}mm" -->
												<xsl:choose>
													<xsl:when test="./test_step_content/function_call">
														<xsl:value-of select="$Text_teststep_content_function_call"/>:&#160;<xsl:value-of select="./test_step_content/function_call/@test_id"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="$Text_teststep"/>:&#160;<xsl:value-of disable-output-escaping="yes" select="./id"/>
													</xsl:otherwise>
												</xsl:choose></p>
										</xsl:with-param>
									</xsl:call-template>
								</td>	
							</xsl:when>	
							<xsl:otherwise>
								<td style="width:auto">
									<p class="default_style_bu">
										<xsl:value-of select="$Text_teststep"/>:&#160;<xsl:value-of disable-output-escaping="yes" select="./id"/></p>
								</td>
							</xsl:otherwise>
						</xsl:choose>
													
						<!-- ZE for test-steps not currently required
						<td style="width:140mm">
							<p class="default_style_sr">
								<xsl:value-of select="$Text_session_time_spent"/>:&#160;&#160;<xsl:value-of disable-output-escaping="yes" select="format-number(./test_step_time_spent,'0.0000')"/>
							</p>
						</td>-->
					</tr>
				</table>
			</xsl:if>

			<!-- display test step content (recursiv) -->
			<xsl:if test="count(./test_step_content)> 0">
				<xsl:choose>
					<xsl:when test="./test_step_content/function_call">
						<span class="treeView_content" id="content_{generate-id(.)}">
							<xsl:call-template name="T2_teststep_content">
								<xsl:with-param name="indentLevel" select="$indentLevel" />
								<xsl:with-param name="hyperrefId">Teststep_<xsl:value-of select="generate-id(.)" /></xsl:with-param>
							</xsl:call-template>
						</span>
					</xsl:when>
					<xsl:otherwise>
						<span class="treeView_content" id="content_{generate-id(.)}">
							<xsl:call-template name="T2_teststep_content">
								<xsl:with-param name="indentLevel" select="$indentLevel" />
							</xsl:call-template>
						</span>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:call-template name="func_treeView_stop" />
		</xsl:for-each>
	</xsl:template>
	<!-- **************************************************************************************************************************** -->
	<!-- template T2_teststep_content-->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T2_teststep_content">
		<xsl:param name="indentLevel" select="0" />
		<xsl:param name="hyperrefId">Teststep_<xsl:value-of select="generate-id(..)" /></xsl:param>
		<xsl:for-each select="test_step_content">
			<xsl:call-template name="T_action">
				<xsl:with-param name="indentLevel" select="$indentLevel" />
			</xsl:call-template>

			<!-- Only display in HTML on root level -->
			<xsl:if test="$indentLevel=0">
 			    <xsl:call-template name="T_cancel">
				    <xsl:with-param name="indentLevel" select="$indentLevel" />
			    </xsl:call-template>
            </xsl:if>

            <xsl:call-template name="T_messwert_lesen_table">
            	<xsl:with-param name="indentLevel" select="$indentLevel" />
            </xsl:call-template>
            <xsl:call-template name="T_standard_measurement">
            	<xsl:with-param name="indentLevel" select="$indentLevel" />
            </xsl:call-template>
            <xsl:call-template name="T_identifikationsdaten_auslesen">
            	<xsl:with-param name="indentLevel" select="$indentLevel" />
            </xsl:call-template>
			<xsl:call-template name="T2_function_call">
				<xsl:with-param name="indentLevel" select="$indentLevel" />
			</xsl:call-template>
			<xsl:call-template name="T2_function_return">
				<xsl:with-param name="indentLevel" select="$indentLevel" />
				<xsl:with-param name="hyperrefId" select="$hyperrefId" />
			</xsl:call-template>
            <xsl:call-template name="T_ecukom">
            	<xsl:with-param name="indentLevel" select="$indentLevel" />
            </xsl:call-template>
		</xsl:for-each>
	</xsl:template>
	<!-- **************************************************************************************************************************** -->
	<!-- template T2_function_call-->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T2_function_call">
		<xsl:param name="indentLevel" select="0" />
		<xsl:if test="count(function_call) > 0">
			<xsl:for-each select="function_call">
				<p class="p_small"/>
				<xsl:if test="param">
					<xsl:call-template name="func_treeView_mark_start">
						<xsl:with-param name="id">parameter_<xsl:value-of select="generate-id(.)"/></xsl:with-param>
					</xsl:call-template>
					<table>
						<thead>
							<tr>
								<th>
									<xsl:call-template name="func_treeView_label">
										<xsl:with-param name="id">parameter_<xsl:value-of select="generate-id(.)"/></xsl:with-param>
										<xsl:with-param name="label"><xsl:value-of select="$Text_call_parameter_group" />:</xsl:with-param>
									</xsl:call-template>
								</th>
							</tr>
						</thead>
						<tbody class="treeView_content">
							<xsl:for-each select="param">
								<tr>
									<td style="width:auto">
										<p style="word-wrap: break-word; word-break: break-all;">
											<xsl:value-of select="./@name"/>:&#160;<xsl:value-of select="."/>
										</p>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
					<xsl:call-template name="func_treeView_stop" />
				</xsl:if>

				<!--  recursiv for test steps -->
				<xsl:call-template name="T2_teststeps">
					<xsl:with-param name="indentLevel" select="$indentLevel+1"/>
					<xsl:with-param name="nodeset" select="test_step"/>
				</xsl:call-template>
				
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	<!-- **************************************************************************************************************************** -->
	<!-- template T2_function_return-->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T2_function_return">
		<xsl:param name="indentLevel" select="0"/>
		<xsl:param name="hyperrefId" select="generate-id(.)" />
		<xsl:if test="count(function_return) > 0">
			<xsl:for-each select="./function_return">
				<p class="p_small"/>
				<!-- Print function return headline label -->
				<table>
					<tr>
						<td style="width:auto">
							<p class="default_style_bu">
								<xsl:value-of select="$Text_teststep_content_function_return"/>:&#160;<xsl:value-of select="@test_id"/>
							</p>
						</td>
					</tr>
				</table>
				<xsl:call-template name="T_general_information">
					<xsl:with-param name="indentLevel" select="$indentLevel" />
					<xsl:with-param name="hyperrefId" select="$hyperrefId" />
					<xsl:with-param name="end_of_test" select="true()" />
				</xsl:call-template>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	
	<!-- **************************************************************************************************************************** -->
	<!-- template T_action-->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_action">
		<xsl:param name="indentLevel" select="0" />
		<xsl:if test="count(action) > 0">
			<xsl:for-each select="action">
				<p class="p_small"/>
				<!-- headline -->
				<table>
					<tr>
						<td>
							<p class="default_style_b">
								<xsl:value-of select="$Text_teststep_content_action"/>:&#160;
								<xsl:choose>
									<xsl:when test="./@id='MESSAGE'"><xsl:value-of select="$Text_workstep_action_type_MESSAGE" /></xsl:when>
									<xsl:when test="./@id='SELECTION'"><xsl:value-of select="$Text_workstep_action_type_SELECTION" /></xsl:when>
									<xsl:when test="./@id='INPUT'"><xsl:value-of select="$Text_workstep_action_type_INPUT" /></xsl:when>
									<xsl:when test="./@id='JUMP'"><xsl:value-of select="$Text_workstep_action_type_JUMP" /></xsl:when>
									<xsl:when test="./@id='ERROR'"><xsl:value-of select="$Text_workstep_action_type_ERROR" /></xsl:when>
									<xsl:when test="./@id='SUBTESTSTEP_START'"><xsl:value-of select="$Text_workstep_action_type_SUBTESTSTEP_START" /></xsl:when>
									<xsl:when test="./@id='SUBTESTSTEP_FINISHED'"><xsl:value-of select="$Text_workstep_action_type_SUBTESTSTEP_FINISHED" /></xsl:when>
									<xsl:otherwise><xsl:value-of select="./@id"/></xsl:otherwise>
								</xsl:choose></p>
						</td>
					</tr>
				</table>
				<!-- in/out -->
				<xsl:for-each select="inout/output">
					<table style="margin-left:1%">
						<tr>
							<td>
								<p>
									<xsl:value-of disable-output-escaping="yes" select="./text_id"/></p>
							</td>
						</tr>
					</table>
					<!--<xsl:for-each select="parameters">
						<table>
							<tbody>
								<tr>
									<td style="width:25mm">&#160;</td>
									<td style="width:140mm">
										<p>
											<xsl:value-of select="$Textteststep_content_action_output_parameter"/>:&#160;&#160;<xsl:value-of select="./name"/>&#160;(<xsl:value-of select="./value"/>)
										</p>
									</td>
								</tr>
							</tbody>
						</table>
					</xsl:for-each>-->
				</xsl:for-each>
				<table>
					<xsl:for-each select="inout/input">
						<tr>
							<td style="width:auto">
								<p class="user_input">
									<xsl:value-of select="$Text_teststep_content_action_input"/>:&#160;<xsl:value-of select="."/></p>
							</td>
						</tr>
					</xsl:for-each>
				</table>
				<!-- jump -->
				<xsl:for-each select="jump">
					<table>
						<tr>
							<td style="width:auto">
								<p>
									<xsl:value-of select="$Text_teststep_content_action_jump"/>:&#160;<xsl:value-of select="."/></p>
							</td>
						</tr>
					</table>
				</xsl:for-each>
				<!-- substep_call -->
				<xsl:for-each select="substep_call">
					<table style="margin-left:1%">
						<tr>
							<td style="width:auto">
								<p><xsl:value-of select="./@test_id"/>&#160;-&#160;<xsl:value-of select="./id"/></p>
							</td>
						</tr>
					</table>
					<p class="p_small"/>
					<xsl:if test="param">
						<xsl:call-template name="func_treeView_mark_start">
							<xsl:with-param name="id">parameter_<xsl:value-of select="generate-id(.)"/></xsl:with-param>
						</xsl:call-template>
						<table style="margin-left:1%">
							<thead>
								<tr>
									<th>
										<xsl:call-template name="func_treeView_label">
											<xsl:with-param name="id">parameter_<xsl:value-of select="generate-id(.)"/></xsl:with-param>
											<xsl:with-param name="label"><xsl:value-of select="$Text_call_parameter_group" />:</xsl:with-param>
										</xsl:call-template>
									</th>
								</tr>
							</thead>
							<tbody class="treeView_content">
								<xsl:for-each select="param">
									<tr>
										<td style="width:auto">
											<p style="word-wrap: break-word; word-break: break-all;">
												<xsl:value-of select="./@name"/>:&#160;<xsl:value-of select="."/>
											</p>
										</td>
									</tr>
								</xsl:for-each>
							</tbody>
						</table>
						<xsl:call-template name="func_treeView_stop" />
					</xsl:if>
				</xsl:for-each>
				<!-- substep_return -->
				<xsl:for-each select="substep_return">
					<table style="margin-left:1%">
						<tr>
							<td style="width:auto">
								<p><xsl:value-of select="./id"/></p>
							</td>
						</tr>
					</table>
				</xsl:for-each>
				<!-- error messages -->
				<xsl:for-each select="error_message">
					<table>
						<tr>
							<td style="width:auto">
								<p>
									<xsl:value-of select="$Text_teststep_content_error_id"/>:&#160;<xsl:value-of select="./error_id"/></p>
							</td>
						</tr>
						<tr>
							<td style="width:auto">
								<p>
									<xsl:value-of select="$Text_teststep_content_error_message"/>:&#160;<xsl:value-of select="./message/text"/></p>
							</td>
						</tr>
					</table>
					<!--<table>
						<tbody>
							<xsl:for-each select="message/parameters">
								<tr>
									<td style="width:25mm">&#160;</td>
									<td style="width:140mm">
										<p>
											<xsl:value-of select="$Text_teststep_content_error_parameter"/>:&#160;&#160;<xsl:value-of select="."/>
										</p>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>-->
				</xsl:for-each>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<!-- **************************************************************************************************************************** -->
	<!-- template T_cancel: test step content for program cancel -->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_cancel">
		<xsl:param name="indentLevel" select="0" />
	    <p class="p_small"/>
		<xsl:if test="count(cancel) > 0">
		  <xsl:for-each select="cancel">
				<table>
					<tr>
						<td style="width:auto">
							<xsl:value-of select="$Text_teststep_content_cancel_reason"/>:&#160;
							<xsl:choose>
								<xsl:when test="reason='WRONG_INPUT'"><xsl:value-of select="$Text_teststep_content_cancel_desc_a1" /></xsl:when>
								<xsl:when test="reason='NOT_CONDUCIVE'"><xsl:value-of select="$Text_teststep_content_cancel_desc_a2" /></xsl:when>
								<xsl:when test="reason='VISUAL_INPECTION_NEEDED'"><xsl:value-of select="$Text_teststep_content_cancel_desc_a3" /></xsl:when>
								<xsl:when test="reason='TEST_REQUIREMENTS'"><xsl:value-of select="$Text_teststep_content_cancel_desc_a4" /></xsl:when>
								<xsl:when test="reason='OTHER'"><xsl:value-of select="$Text_teststep_content_cancel_desc_a5" /></xsl:when>
								<xsl:otherwise><xsl:value-of select="reason"/></xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
					<xsl:if test="description">
						<tr>
							<td style="width:auto">
								<xsl:value-of select="$Text_teststep_content_cancel_hint"/>:&#160;<xsl:value-of select="description"/>
							</td>
						</tr>
					</xsl:if>
				</table>
		  </xsl:for-each>
		</xsl:if>
    </xsl:template>

	<!-- **************************************************************************************************************************** -->
	<!-- template T_measurement_protocol_entries: test step content for generic translateble measurement texts -->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_measurement_protocol_entries">
		<xsl:param name="indentLevel" select="0" />
	    <p class="p_small"/>

		<xsl:if test="count(measurement_protocol_entries) > 0">
		  <!-- headline -->
          <table>
			<tr>
			  <td style="width:auto">
				<p class="default_style_bu">
				  <xsl:value-of select="$Text_teststep_content_standard_measurement"/>:
				</p>
			  </td>
			</tr>
          </table>
		  <xsl:for-each select="measurement_protocol_entries">
			<table>
				<xsl:for-each select="measurementEntries">
					<tr>
						<td style="width:44.5%">
							<p>
								<xsl:value-of disable-output-escaping="yes" select="./keyText/text_id"/>
							</p>
						</td>
						<td style="width:55.5%">
							<p>
								<xsl:value-of disable-output-escaping="yes" select="./valueText/text_id"/>
							</p>
						</td>
					</tr>
				</xsl:for-each>
			</table>
		  </xsl:for-each>
		</xsl:if>
    </xsl:template>

    <!-- **************************************************************************************************************************** -->
    <!-- template T_standard_measurement-->
    <!-- **************************************************************************************************************************** -->
    <xsl:template name="T_standard_measurement">
    	<xsl:param name="indentLevel" select="0" />
        <xsl:if test="count(standard_measurement) > 0">
            <xsl:for-each select="standard_measurement">
                <p class="p_small"/>
                <!-- headline -->
                <table>
					<tr>
						<td style="width:auto">
							<p class="default_style_bu">
								<xsl:value-of select="$Text_teststep_content_standard_measurement"/>:</p>
						</td>
					</tr>
                </table>
                <table>
                        <!-- in/out -->
                        <xsl:for-each select="inout/output">
                            <tr>
                                <td style="width:44.5%">
                                    <p>
                                        <xsl:value-of select="$Text_teststep_content_action_output"/>:&#160;</p>
                                </td>
                                <td style="width:55.5%">
                                    <p>
                                        <xsl:value-of disable-output-escaping="yes" select="./text_id"/></p>
                                </td>
                            </tr>
                            <!--<xsl:for-each select="parameters">
                                <tr>
                                <td style="width:45mm">&#160;</td>
                                <td style="width:80mm">
                                    <p>
                                        <xsl:value-of select="$Textteststep_content_action_output_parameter"/>:&#160;&#160;
                                    </p>
                                </td>
                                <td style="width:100mm">
                                    <p>
                                        <xsl:value-of select="./name"/>&#160;(<xsl:value-of select="./value"/>)
                                    </p>
                                </td>
                            </tr>
                        </xsl:for-each>-->
                    </xsl:for-each>
                        <xsl:for-each select="inout/input">
                            <tr>
                                <td style="width:44.5%">
                                    <p>
                                        <xsl:value-of select="$Text_teststep_content_action_input"/>:160;</p>
                                </td>
                                <td style="width:55.5%">
                                    <p>
                                        <xsl:value-of select="."/>
                                    </p>
                                </td>
                            </tr>
                        </xsl:for-each>
                        <xsl:for-each select="error">
                            <tr>
                                <td style="width:44.5%">
                                    <p>
                                        <xsl:value-of select="$Text_standard_measurement_error"/>:&#160;</p>
                                </td>
                                <td style="width:55.5%">
                                    <p>
                                        <xsl:value-of select="./message/text"/></p>
                                </td>
                            </tr>
                        </xsl:for-each>
                        <xsl:if test="count(used_hardware) > 0">
                            <tr>
                                <td style="width:44.5%">
                                    <p>
                                        <xsl:value-of select="$Text_standard_measurement_used_hardware"/>:</p>
                                </td>
                                <td style="width:55.5%">
                                    <p>
                                        <xsl:value-of select="used_hardware"/></p>
                                </td>
                            </tr>
                        </xsl:if>
                        <xsl:if test="count(measurement_type_id) > 0">
                            <tr>
                                <td style="width:44.5%">
                                    <p>
                                        <xsl:value-of select="$Text_standard_measurement_type"/>:</p>
                                </td>
                                <td style="width:55.5%">
                                    <p>
                                        <xsl:value-of select="measurement_type_id"/></p>
                                </td>
                            </tr>
                        </xsl:if>
                        <xsl:if test="count(tolerance_io) > 0">
                            <tr>
                                <td style="width:44.5%">
                                    <p>
                                        <xsl:value-of select="$Text_standard_measurement_tolerance_io"/>:</p>
                                </td>
                                <td style="width:55.5%">
                                    <p>
                                        <xsl:value-of select="tolerance_io"/>&#160;<xsl:value-of select="unit"/></p>
                                </td>
                            </tr>
                        </xsl:if>
                        <xsl:if test="count(tolerance_nio) > 0">
                            <tr>
                                <td style="width:44.5%">
                                    <p>
                                        <xsl:value-of select="$Text_standard_measurement_tolerance_nio"/>:
                                    </p>
                                </td>
                                <td style="width:55.5%">
                                    <p>
                                        <xsl:value-of select="tolerance_nio"/>&#160;<xsl:value-of select="unit"/></p>
                                </td>
                            </tr>
                        </xsl:if>
                        <xsl:if test="count(value) > 0">
                            <tr>
                                <td style="width:44.5%">
                                    <p>
                                        <xsl:choose>
                                            <xsl:when test="Source='USER'">
                                                <xsl:value-of select="$Text_standard_measurement_replacement_value"/>:
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:value-of select="$Text_standard_measurement_value"/>:
                                            </xsl:otherwise>
                                        </xsl:choose></p>
                                </td>
                                <td style="width:55.5%">
                                    <p>
                                        <xsl:value-of select="value"/>&#160;<xsl:value-of select="unit"/>
                                    </p>
                                </td>
                            </tr>
                        </xsl:if>
                        <xsl:if test="count(state) > 0">
                            <tr>
                                <td style="width:44.5%">
                                    <p>
                                        <xsl:value-of select="$Text_standard_measurement_state"/>:</p>
                                </td>
                                <td style="width:55.5%">
                                    <p>
                                        <xsl:value-of select="state"/></p>
                                </td>
                            </tr>
                        </xsl:if>
                        <xsl:if test="count(errorcode) > 0">
                            <tr>
                                <td style="width:44.5%">
                                    <p>
                                        <xsl:value-of select="$Text_standard_measurement_errorcode"/>:</p>
                                </td>
                                <td style="width:55.5%">
                                    <p>
                                        <xsl:value-of select="errorcode"/></p>
                                </td>
                            </tr>
                        </xsl:if>
                        <xsl:if test="count(device_identification) > 0">
                            <tr>
                                <td style="width:44.5%">
                                    <p>
                                        <xsl:value-of select="$Text_standard_measurement_device_identification"/>:</p>
                                </td>
                                <td style="width:55.5%">
                                    <p>
                                        <xsl:value-of select="device_identification"/></p>
                                </td>
                            </tr>
                        </xsl:if>
                        <xsl:if test="count(firmware) > 0">
                            <tr>
                                <td style="width:44.5%">
                                    <p>
                                        <xsl:value-of select="$Text_standard_measurement_firmware"/>:</p>
                                </td>
                                <td style="width:55.5%">
                                    <p>
                                        <xsl:value-of select="firmware"/></p>
                                </td>
                            </tr>
                        </xsl:if>
                </table>
				<xsl:if test="count(check_sensor) > 0">
					<xsl:for-each select="check_sensor">
						<xsl:call-template name="T_check_sensor">
							<xsl:with-param name="indentLevel" select="$indentLevel" />
							<xsl:with-param name="check_sensor" select="." />
						</xsl:call-template>
					</xsl:for-each>
				</xsl:if>
            </xsl:for-each>
        </xsl:if>
    </xsl:template>
    <!-- **************************************************************************************************************************** -->
    <!-- template T_check_sensor -->
    <!-- **************************************************************************************************************************** -->
    <xsl:template name="T_check_sensor">
    	<xsl:param name="indentLevel" select="0" />
    	<xsl:param name="check_sensor"/>
        
		<table>
			<tr>
				<td style="width:auto">
					<p>
						<span class="weight_bold"><xsl:value-of select="$Text_standard_measurement_check_sensor"/></span></p>
				</td>
			</tr>
		</table>
		<table>
			<tr>
				<td>
					<p>
						<span class="weight_bold"><xsl:value-of select="$Text_standard_measurement_check_sensor_connector"/></span></p>
				</td>
				<td>
					<p>
						<xsl:value-of select="$check_sensor/connector"/></p>
				</td>
			</tr>
			<tr>
				<td>
					<p>
						<span class="weight_bold"><xsl:value-of select="$Text_standard_measurement_check_sensor_sensor"/></span>
					</p>
				</td>
				<td>
					<p>
						<xsl:value-of select="$check_sensor/sensor_name"/></p>
				</td>
			</tr>
			<tr>
				<td>
					<p>
						<span class="weight_bold"><xsl:value-of select="$Text_standard_measurement_check_sensor_result"/></span></p>
				</td>
				<td>
					<p>
						<xsl:choose>
							<xsl:when test="$check_sensor/errorcode='0'">
								<span class="color_green"><xsl:value-of select="$check_sensor/errorcode"/></span>
							</xsl:when>
							<xsl:otherwise>
								<span class="color_red"><xsl:value-of select="$check_sensor/errorcode"/></span>
							</xsl:otherwise>
						</xsl:choose></p>
				</td>
			</tr>
		</table>
	</xsl:template>
    <!-- **************************************************************************************************************************** -->
    <!-- template T_identifikation_auslesen -->
    <!-- **************************************************************************************************************************** -->
    <xsl:template name="T_identifikationsdaten_auslesen">
    	<xsl:param name="indentLevel" select="0" />
        <xsl:if test="count(identifikationsdaten_auslesen) > 0">
            <xsl:for-each select="identifikationsdaten_auslesen">
                <p class="p_small"/>
                <!-- headline -->
                <table>
					<tr>
						<td style="width:60%">
							<p class="default_style_b">
								<xsl:value-of select="$Text_teststep_content_identifikation_auslesen"/></p>
						</td>
						<td style="width:auto"/>
					</tr>
					<tr>
						<td/>
						<td>
							<p>
								<xsl:value-of select="$Text_teststep_content_identifikation_auslesen_read_subsystems"/>:</p>
						</td>
						<td>
							<p>
								<xsl:value-of select="./ident_subsystems/@textID"/></p>
						</td>
					</tr>
					<tr>
						<td/>
						<td>
							<p>
								<xsl:value-of select="$Text_teststep_content_identifikation_auslesen_status"/>:</p>
						</td>
						<td>
							<p>
								<xsl:choose>
									<xsl:when test="./ident_status='1'">
										<span class="color_green"><xsl:value-of select="./ident_status/@textID"/></span>
									</xsl:when>
									<xsl:otherwise>
										<span class="color_red"><xsl:value-of select="./ident_status/@textID"/></span>
									</xsl:otherwise>
								</xsl:choose></p>
						</td>
					</tr>
					<xsl:if test="count(./EcuTrace/Ecu) > 0">
						<tr>
							<td style="width:60%">
								<p class="default_style_b">
									<xsl:value-of select="$Text_teststep_content_identifikation_auslesen_ecus"/>:</p>
							</td>
							<td style="width:auto"/>
						</tr>
					</xsl:if>
                </table>
                <xsl:if test="count(./EcuTrace/Ecu) > 0">
					<xsl:call-template name="func_treeView_mark_start"/>
						<xsl:call-template name="func_treeView_label">
							<xsl:with-param name="label">&#160;</xsl:with-param>
						</xsl:call-template>
						<span class="treeView_content">
						<table>
							<tr>
								<td style="width:auto">
									<xsl:for-each select="./EcuTrace">
										<xsl:call-template name="T_Ecus">
											<xsl:with-param name="withEvents" select="false()"/>
										</xsl:call-template>
									</xsl:for-each>
								</td>
							</tr>
						</table>
						</span>
					<xsl:call-template name="func_treeView_stop" />
				</xsl:if>
            </xsl:for-each>
        </xsl:if>
    </xsl:template>
	<!-- **************************************************************************************************************************** -->
	<!-- template T_messwert_lesen_table-->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_messwert_lesen_table">
		<xsl:param name="indentLevel" select="0" />
		<xsl:if test="count(messwert_lesen_table) > 0">
			<xsl:for-each select="messwert_lesen_table">
				<p class="p_small"/>
				<!-- headline -->
				<table>
					<tr>
						<td>
							<p class="default_style_bu">
								<xsl:value-of select="$Text_teststep_content_measurement_value"/>:
								<xsl:if test="./notice_id != '(not yet implemented)'">
									&#160;<xsl:value-of select="./notice_id"/>
								</xsl:if></p>
						</td>
					</tr>
				</table>
				<xsl:if test="count(table_content) > 0">
					<table>
						<tr>
							<td style="width:28.5%">
								<p>
									<xsl:value-of select="$Text_measurement_value_name"/>:</p>
							</td>
							<td style="width:18%">
								<p>
									<xsl:value-of select="$Text_measurement_value_value"/>:</p>
							</td>
							<td style="width:28.5%">
								<p>
									<xsl:value-of select="$Text_measurement_value_target_value"/>:</p>
							</td>
							<td style="width:25%">
								<p>
									<xsl:value-of select="$Text_measurement_value_identification"/>:</p>
							</td>
<!--								<td>  -->
<!--									<p>  -->
<!--										<xsl:value-of select="$Text_measurement_value_button"/>:  -->
<!--									</p>  -->
<!--								</td>  -->
						</tr>
						<xsl:for-each select="./table_content">
							<tr>
								<td>
									<p>
										<xsl:value-of select="./name_id"/></p>
								</td>
								<td>
									<p>
										<xsl:value-of select="./measured_value"/></p>
								</td>
								<td>
									<p>
										<xsl:value-of select="./nominal_value"/></p>
								</td>
								<td>
									<p>
										<xsl:value-of select="./measured_data_identification"/></p>
								</td>
<!-- 									<td>  -->
<!-- 										<p>  -->
<!-- 											<xsl:value-of select="./button_testproc_pressed"/>  -->
<!-- 										</p>  -->
<!-- 									</td>  -->
							</tr>
						</xsl:for-each>
					</table>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	<!-- **************************************************************************************************************************** -->
	<!-- template T_function_call-->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_function_call">
		<xsl:param name="indentLevel" select="0" />
		<xsl:if test="count(function_call) > 0">
			<xsl:for-each select="function_call">
				<p class="p_small"/>
				<xsl:if test="param">
					<xsl:call-template name="func_treeView_mark_start">
						<xsl:with-param name="id">parameter_<xsl:value-of select="generate-id(.)"/></xsl:with-param>
					</xsl:call-template>
					<table>
						<thead>
							<tr>
								<th>
									<xsl:call-template name="func_treeView_label">
										<xsl:with-param name="id">parameter_<xsl:value-of select="generate-id(.)"/></xsl:with-param>
										<xsl:with-param name="label"><xsl:value-of select="$Text_call_parameter_group" />:</xsl:with-param>
									</xsl:call-template>
								</th>
							</tr>
						</thead>
						<tbody class="treeView_content">
							<xsl:for-each select="param">
								<tr>
									<td style="width:auto">
										<p style="word-wrap: break-word; word-break: break-all;">
											<xsl:value-of select="./@name"/>:&#160;<xsl:value-of select="."/>
										</p>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
					<xsl:call-template name="func_treeView_stop" />
				</xsl:if>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	<!-- **************************************************************************************************************************** -->
	<!-- template T_function_return-->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_function_return">
		<xsl:param name="indentLevel" select="0"/>
		<xsl:param name="returnNodeId" select="self::test_step_content/../@runtime_id" />
		<xsl:param name="returnNode" select="(self::test_step_content/.. | self::test_step_content/../following-sibling::test_step)[@runtime_id = $returnNodeId][1]" />
		<xsl:param name="hyperrefId" select="generate-id(.)" />
		<xsl:if test="count($returnNode/test_step_content/function_return) > 0">
			<xsl:for-each select="$returnNode/test_step_content/function_return">
<!-- 			<xsl:message>Processing function return from <xsl:value-of select="../../@runtime_id" /> (<xsl:value-of select="./@test_id" />) to <xsl:value-of select="$returnNode/@runtime_id" /> (<xsl:value-of select="$returnNode/test_step_content/function_return/@test_id" />)</xsl:message> -->
				<xsl:call-template name="T_general_information">
					<xsl:with-param name="indentLevel" select="$indentLevel" />
					<xsl:with-param name="hyperrefId" select="$hyperrefId" />
					<xsl:with-param name="end_of_test" select="true()" />
				</xsl:call-template>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	<!-- **************************************************************************************************************************** -->
	<!-- template T_ecukom-->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_ecukom">
		<xsl:param name="indentLevel" select="0" />
		<xsl:if test="count(ecukom) > 0">
			<xsl:for-each select="ecukom">
				<p class="p_small"/>
				<!-- headline -->
				<table>
					<tr>
						<td>
							<p class="default_style_bu">
								<xsl:value-of select="$Text_teststep_content_ecukom"/>
								<xsl:text/>&#160;(<xsl:text/>
								<xsl:choose>
									<xsl:when test="./@type='1'">
										<xsl:value-of select="$Text_teststep_content_ecukom_type_KWP"/>
									</xsl:when>
									<xsl:when test="./@type='2'">
										<xsl:value-of select="$Text_teststep_content_ecukom_type_UDS"/>
									</xsl:when>
									<xsl:when test="./@type='3'">
										<xsl:value-of select="$Text_teststep_content_ecukom_type_KWP_functional"/>
									</xsl:when>
									<xsl:when test="./@type='4'">
										<xsl:value-of select="$Text_teststep_content_ecukom_type_UDS_functional"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$Text_teststep_content_ecukom_type_unknown"/>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:text/>):&#160;<xsl:text/>
							</p>
						</td>
					</tr>
				</table>
				<!-- link, jobstatus -->
				<table>
					<tr>
						<td>
							<p>
								<span class="weight_bold"><xsl:value-of select="$Text_teststep_content_ecukom_link"/>:&#160;</span>
								<xsl:call-template name="T_formatEcuName">
									<xsl:with-param name="type"><xsl:value-of select="./@type"/></xsl:with-param>
									<xsl:with-param name="link"><xsl:value-of select="./@logical_link"/></xsl:with-param>
									<xsl:with-param name="ecuname"><xsl:value-of select="./response/ecu_name"/></xsl:with-param>
								</xsl:call-template></p>
						</td>
					</tr>
					<tr>
						<td>
							<p class="default_style_b">
								<xsl:value-of select="$Text_teststep_content_ecukom_jobstatus"/>:&#160;<xsl:choose>
									<xsl:when test="./@job_status='OKAY'">
										<span class="color_green"><xsl:value-of select="./@job_status"/></span>
									</xsl:when>
									<xsl:otherwise>
										<span class="color_red"><xsl:value-of select="./@job_status"/></span>
									</xsl:otherwise>
								</xsl:choose></p>
						</td>
					</tr>
				</table>
				<xsl:call-template name="func_treeView_mark_start">
					<xsl:with-param name="id">ecukom_service_<xsl:value-of select="generate-id(.)"/></xsl:with-param>
				</xsl:call-template>
				<!-- ecu_service -->
				<table>
					<tr>
						<td>
							<xsl:call-template name="func_treeView_label">
								<xsl:with-param name="id">ecukom_service_<xsl:value-of select="generate-id(.)"/></xsl:with-param>
								<xsl:with-param name="label">
									<!-- <span class="default_style_b"><xsl:value-of select="$Text_teststep_content_ecukom_service"/>:&#160;<xsl:value-of select="./request/ecu_service"/></span> -->
									<xsl:call-template name="T_formatService">
										<xsl:with-param name="request" select="./request"/>
									</xsl:call-template>
								</xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
				</table>
				<!-- Header line for request parameters -->
				<table class="treeView_content">
					<tr>
						<td>
							<p class="default_style_b">
								<xsl:value-of select="$Text_teststep_content_ecukom_request_parameter"/>:&#160;</p>
						</td>
					</tr>
				</table>
				<!-- the request parameters, or the message 'no parameters' -->
				<xsl:choose>
					<xsl:when test="count(./request/parameter) > 0">
						<table class="treeView_content" style="margin-left:4%">
							<thead>
								<tr>
									<th>
										<p>
										<xsl:choose>
											<xsl:when test="./@type='1'">
												<xsl:value-of select="$Text_teststep_content_ecukom_request_parameter_index"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$Text_teststep_content_ecukom_request_parameter_name"/>
											</xsl:otherwise>
										</xsl:choose></p>
									</th>
									<th>
										<p>
											<xsl:value-of select="$Text_teststep_content_ecukom_request_parameter_value"/></p>
									</th>
								</tr>
							</thead>
							<xsl:for-each select="./request/parameter">
								<tr>
									<td>
										<xsl:call-template name="T_cutStringInEqualPieces">
											<xsl:with-param name="size" select="45"/>
											<xsl:with-param name="stringValue" select="./name"/>
										</xsl:call-template>
									</td>
									<td>
										<xsl:call-template name="T_cutStringInEqualPieces">
											<xsl:with-param name="size" select="18"/>
											<xsl:with-param name="stringValue" select="concat(./value, '&#160;', ./unit)"/>
										</xsl:call-template>
									</td>
								</tr>
							</xsl:for-each>
						</table>
					</xsl:when>
					<xsl:otherwise>
						<table class="treeView_content" style="margin-left:4%">
							<tr>
								<td>
									<p>
										<xsl:value-of select="$Text_teststep_content_ecukom_request_no_param"/>&#160;</p>
								</td>
							</tr>
						</table>
					</xsl:otherwise>
				</xsl:choose>
				
				<!-- loop over all responses -->
				<xsl:for-each select="./response">
					<xsl:choose>
						<xsl:when test="not(./@available) or ./@available = 'true'">
							<!-- ecu did respond -->
							<table class="treeView_content">
								<xsl:choose>
									<xsl:when test="./neg_serviceid or ./neg_resp_code">
										<!-- NRC -->
										<tr>
											<td>
												<p>
													<xsl:value-of select="$Text_teststep_content_ecukom_response_nrc"/>&#160;-&#160;<xsl:call-template name="T_IntToHex">
				<xsl:with-param name="in" select="./neg_serviceid"/></xsl:call-template>&#160;-&#160;<xsl:call-template name="T_IntToHex">
				<xsl:with-param name="in" select="./neg_resp_code"/></xsl:call-template></p>
											</td>
										</tr>
									</xsl:when>
									<xsl:otherwise>
										<!-- header line for response parameters -->
										<tr>
											<td>
												<!-- <p> #Fehler: Element “p” not allowed as child of element “span” in this context. (Suppressing further errors from this subtree.)
 -->
													<xsl:call-template name="T_formatRespondingEcu">
														<xsl:with-param name="response" select="."/>
													</xsl:call-template> <!--</p>-->
											</td>
										</tr>
									</xsl:otherwise>
								</xsl:choose>
							</table>
							
							<!-- the response parameters, or the message 'no parameters' -->
							<xsl:choose>
								<xsl:when test="count(./parameter) > 0">
									<table style="margin-left:4%" class="treeView_content">
										<thead>
											<tr>
												<th>
													<p>
														<xsl:value-of select="$Text_teststep_content_ecukom_response_parameter_name"/></p>
												</th>
												<th>
													<p>
														<xsl:value-of select="$Text_teststep_content_ecukom_response_parameter_value"/></p>
												</th>
											</tr>
										</thead>
										<xsl:for-each select="./parameter">
											<tr>
												<td>
													<xsl:call-template name="T_cutStringInEqualPieces">
														<xsl:with-param name="size" select="45"/>
														<xsl:with-param name="stringValue" select="./name"/>
													</xsl:call-template>
												</td>
												<td>
													<xsl:call-template name="T_cutStringInEqualPieces">
														<xsl:with-param name="size" select="18"/>
														<xsl:with-param name="stringValue" select="concat(./value, '&#160;', ./unit)"/>
													</xsl:call-template>
												</td>
											</tr>
										</xsl:for-each>
									</table>
								</xsl:when>
								<xsl:otherwise>
									<table class="treeView_content">
										<tr>
											<td>
												<p style="margin-left:4%">
													<xsl:value-of select="$Text_teststep_content_ecukom_response_no_param"/></p>
											</td>
										</tr>
									</table>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<!-- response not available -->
							<table class="treeView_content">
								<tr>
									<td>
										<p>
											<xsl:value-of select="$Text_teststep_content_ecukom_no_response"/>:&#160;<xsl:value-of select="./ecu_name"/></p>
									</td>
								</tr>
							</table>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
				<xsl:call-template name="func_treeView_stop" />
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	<!-- **************************************************************************************************************************** -->
	<!-- template T_local_variables-->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_local_variables">
		<!-- local variables -->
		<xsl:if test="count(local_variables/variable) > 0">
			<p class="p_small"/>
			<table>
				<tr>
					<td>
						<p class="default_style_bu">
							<xsl:value-of select="$Text_functiontest_local_variables"/>:</p>
					</td>
				</tr>
			</table>
			<table style="margin-left:1%">
				<thead>
					<tr>
						<th>
							<p>
								<xsl:value-of select="$Text_functiontest_local_variables_name"/>:</p>
						</th>
						<th>
							<p>
								<xsl:value-of select="$Text_functiontest_local_variables_type"/>:</p>
						</th>
						<th>
							<p>
								<xsl:value-of select="$Text_functiontest_local_variables_content"/>:</p>
						</th>
					</tr>
				</thead>
				<xsl:for-each select="local_variables/variable">
					<tr>
						<td>
							<p>
								<xsl:value-of select="./@name"/></p>
						</td>
						<td>
							<p>
								<xsl:value-of select="./@type"/></p>
						</td>
						<td>
							<p>
								<xsl:value-of select="."/></p>
						</td>
					</tr>
				</xsl:for-each>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- **************************************************************************************************************************** -->
	<!-- template T_IntToHex -->
	<!-- outputs the integer input value as hex. works recursively, so be careful with very large values. -->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_IntToHex">
	  <xsl:param name="in"/>
		<xsl:choose>
			<xsl:when test="$in = 0">0</xsl:when>
			<xsl:when test="$in &lt;= 16">
				<xsl:value-of select="substring('123456789ABCDEF', $in mod 16, 1)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="T_IntToHex">
					<xsl:with-param name="in" select="$in div 16"/>
				</xsl:call-template>
				<xsl:call-template name="T_IntToHex">
					<xsl:with-param name="in" select="$in mod 16"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- **************************************************************************************************************************** -->
	<!-- template T_formatEcuName -->
	<!-- outputs the ecu name consisting of logical link and name, depending on the ecukom type. -->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_formatEcuName">
	  <xsl:param name="type"/>
	  <xsl:param name="link"/>
	  <xsl:param name="ecuname"/>
		<xsl:choose>
			<!-- physical call, show name and link -->
			<xsl:when test="($type = 1) or ($type = 2) "><xsl:value-of select="$ecuname"/>&#160;(<xsl:value-of select="$link"/>)</xsl:when>
			<!-- functional call, show only the link name -->
			<xsl:otherwise>
				<xsl:value-of select="$link"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- **************************************************************************************************************************** -->
	<!-- template T_formatService -->
	<!-- outputs the service name and value of a special request param, if existing. -->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_formatService">
	  <xsl:param name="request"/>
		<span class="default_style_b">
			<xsl:value-of select="$Text_teststep_content_ecukom_service"/>:&#160;<xsl:value-of select="$request/ecu_service"/>
			<xsl:for-each select="$request/parameter">
				<xsl:if test="contains(name,'Param_RecorDataIdent')">
					<xsl:text/>&#160;(<xsl:text/>
					<xsl:value-of select="value"/>
					<xsl:text/>)<xsl:text/>
				</xsl:if>
			</xsl:for-each>
		</span>
	</xsl:template>
	<!-- **************************************************************************************************************************** -->
	<!-- template T_formatRespondingEcu -->
	<!-- outputs the service name and value of a special request param, if existing. -->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_formatRespondingEcu">
	  <xsl:param name="response"/>
		<span class="default_style_b">
			<xsl:value-of select="$Text_teststep_content_ecukom_response_parameter"/>
			<xsl:if test="($response/../@type = 3) or ($response/../@type = 4)">
				<xsl:text/>&#160;(<xsl:text/>
				<xsl:value-of select="$response/ecu_name"/>
				<xsl:text/>)<xsl:text/>
			</xsl:if>
			<xsl:text/>:<xsl:text/>
		</span>
	</xsl:template>

	<!-- **************************************************************************************************************************** -->
	<!-- template T_formatRespondingEcu -->
	<!-- outputs the service name and value of a special request param, if existing. -->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_cutStringInEqualPieces">
	  <xsl:param name="size"/>
	  <xsl:param name="stringValue"/>
	  
		<xsl:if test="string-length($stringValue) &gt; $size"> 
			<p>
	  			<xsl:value-of select="substring($stringValue, 1, $size)"/>
			</p>

	  		<xsl:call-template name="T_cutStringInEqualPieces">
				<xsl:with-param name="size" select="$size"/>
				<xsl:with-param name="stringValue" select="substring($stringValue, ($size + 1))"/>
			</xsl:call-template>
	  	</xsl:if>
	  	<xsl:if test="string-length($stringValue) &lt; ($size + 1)">	  		
			<p> 
	  			<xsl:value-of select="$stringValue"/>
	  		</p>
	  	</xsl:if>
	</xsl:template>
</xsl:stylesheet>
