﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="function_templates.xsl"/>
	<!-- *************************************************** Versionsvariablen *************** -->
	<!-- %version: 22 %  (for a complete list use Synergy/CCM)                                 -->
	<!-- *************************************************** Versionsvariablen *************** -->
	<xsl:variable name="V_Stylesheet_Version_testplans" select="'2.1'"/>
	<xsl:variable name="V_Stylesheet_Datum_testplans" select="'29.09.2021'"/>
	<!-- **************************************************************************************************************************** -->
	<!-- template T_testplans-->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_testplans">
		<p class="header_style_middle_bu">
			<xsl:value-of select="$Text_testplans"/></p>
		<xsl:if test="count(guided_fault_finding/diagnosis_log/test_plan)=0">
			<p>
				<xsl:value-of select="$Text_no_testplans"/></p>
		</xsl:if>
		<xsl:for-each select="guided_fault_finding/diagnosis_log/test_plan">
			<p class="p_small"/>
			<!-- headline -->
			<p class="header_style_middle_bu_12">
				<xsl:value-of select="$Text_testplan"/>&#160;<xsl:value-of select="./test_plan_number"/></p>
			<xsl:if test="count(./function_test) = 0 and count(./vehicle_problem_in_test_plan) = 0">
				<p><xsl:value-of select="$Text_no_functiontests"/></p>
			</xsl:if>
			<!-- data -->
			<xsl:for-each select="./function_test">
				<table>
					<tr>
						<td>
							<p>
								<xsl:variable name="current_function_test_id" select="./function_test_id"/>
								<xsl:value-of select="$current_function_test_id"/>
								<xsl:for-each select="./../../function_test[./function_test_id = $current_function_test_id]">&#160;<xsl:call-template name="func_hyperref_label">
									<xsl:with-param name="link"><span class="number_plus_link_symbol_for_functiontest"><xsl:value-of select="./function_test_number" /></span></xsl:with-param>
								</xsl:call-template>
								</xsl:for-each></p>
						</td>
						<td class="align_opposite">
							<xsl:if test="@unjustified = 'true'">
							    <p class="very_small_style"><xsl:value-of select="$Text_testplan_unjustified"/></p>
							</xsl:if>
							<xsl:if test="@dtcFactor">
								<p class="very_small_style">
									<xsl:value-of select="$Text_dtc_factor" />
									<xsl:text>: </xsl:text>
									<xsl:value-of select="@dtcFactor" />
								</p>
							</xsl:if>
							<xsl:if test="@status = 'INHERITED_FAULT'">
							    <p class="very_small_style"><xsl:value-of select="$Text_testplan_inherited_fault"/></p>
							</xsl:if>
							<xsl:if test="@status = 'DEPENDENT_OK'">
							    <p class="very_small_style"><xsl:value-of select="$Text_testplan_implicit_IO"/></p>
							</xsl:if>
						</td>
					</tr>
				</table>
				<!-- faults -->
				<xsl:if test="count(./fault)>0">
					<table style="margin-left:5mm">
						<!-- header -->
						<tr>
							<td>
								<p>
									<xsl:value-of select="$Text_testplan_fault"/>:</p>
							</td>
						</tr>
						<tr>
							<td>
								<p>
									<xsl:value-of select="$Text_testplan_fault_ecu_variant"/></p>
							</td>
							<td>
								<p>
									<xsl:value-of select="$Text_testplan_fault_fault_number"/></p>
							</td>
						</tr>
						<xsl:for-each select="./fault">
							<tr>
								<td>
									<p>
										<xsl:value-of select="./ecu_variant"/></p>
								</td>
								<td>
									<p>
										<xsl:if test="count(./Fault_Code) > 0">
											<xsl:value-of disable-output-escaping="yes" select="./Fault_Code"/>:&#160;
										</xsl:if>
										<xsl:value-of disable-output-escaping="yes" select="./fault_number"/></p>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</xsl:if>
			</xsl:for-each>

			<!-- show different table for UGD test plans -->
			<xsl:call-template name="T_testplanProblems"/>	
		</xsl:for-each>
	</xsl:template>
	
	<!-- **************************************************************************************************************************** -->
	<!-- template T_testplanProblems-->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_testplanProblems">
		<xsl:for-each select="./vehicle_problem_in_test_plan">
			<table>
				<tr>
					<td>
						<p>
							<xsl:value-of select="./test_plan_problem_id"/>
						</p>
					</td>
					<td class="align_opposite">
						<xsl:if test="@dtcFactor">
							<p class="very_small_style">
								<xsl:value-of select="$Text_dtc_factor" />
								<xsl:text>: </xsl:text>
								<xsl:value-of select="@dtcFactor" />
							</p>
						</xsl:if>
					</td>
				</tr>
			</table>			
			
			<!-- faults -->
			<xsl:if test="count(./fault)>0">
				<!-- fault header -->
				<table style="margin-left:10px">
					<tr>
						<td>
							<p>
								<xsl:value-of select="$Text_testplan_fault"/>:</p>
						</td>
					</tr>
				</table>
				<table style="margin-left:20px">
					<tr>
						<td>
							<p>
								<xsl:value-of select="$Text_testplan_fault_ecu_variant"/>
							</p>
						</td>
						<td>
							<p>
								<xsl:value-of select="$Text_testplan_fault_fault_number"/>
							</p>
						</td>
					</tr>
					<xsl:for-each select="./fault">
						<tr>
							<td>
								<p>
									<xsl:value-of select="./ecu_variant"/>
								</p>
							</td>
							<td>
								<p>
									<xsl:if test="count(./Fault_Code) > 0">
										<xsl:value-of disable-output-escaping="yes" select="./Fault_Code"/>:&#160;
									</xsl:if>
									<xsl:value-of disable-output-escaping="yes" select="./fault_number"/>
								</p>
							</td>
						</tr>
					</xsl:for-each>
				</table>
			</xsl:if>
			<!-- Function test of the problems -->
			<xsl:for-each select="./ugd_function_test">
				<!-- Function test header -->
				<table style="margin-left:10px;width:790px">
					<tr>
						<td>
							<p>
								<xsl:variable name="current_function_test_id" select="."/>
								<xsl:value-of select="$current_function_test_id"/>
								<xsl:for-each select="guided_fault_finding/diagnosis_log/function_test[./function_test_id = $current_function_test_id]">&#160;<xsl:call-template name="func_hyperref_label">
									<xsl:with-param name="link"><span class="number_plus_link_symbol_for_functiontest"><xsl:value-of select="./function_test_number" /></span></xsl:with-param>
									</xsl:call-template>
								</xsl:for-each>
							</p>
						</td>
						<td class="align_opposite">
							<xsl:if test="@unjustified = 'true'">
								<p class="very_small_style"><xsl:value-of select="$Text_testplan_unjustified"/></p>
							</xsl:if>
							<xsl:if test="@status = 'INHERITED_FAULT'">
							    <p class="very_small_style"><xsl:value-of select="$Text_testplan_inherited_fault"/></p>
							</xsl:if>
							<xsl:if test="@status = 'DEPENDENT_OK'">
							    <p class="very_small_style"><xsl:value-of select="$Text_testplan_implicit_IO"/></p>
							</xsl:if>
						</td>
					</tr>
				</table>
				<!-- Repair location and probabilities of the test program. -->
				<table style="margin-left:20px">
					<tr>
						<td>
							<p><xsl:value-of select="$Text_testplan_repair_probability"/>:</p>
						</td>
						<td>
							<xsl:if test="@repair_probability &gt; 0">
								<xsl:value-of select="format-number(@repair_probability, '#0.0')"/>
								<xsl:text> %</xsl:text>
							</xsl:if>
							<xsl:if test="@repair_probability &lt;= 0">
								<xsl:text>n/a</xsl:text>
							</xsl:if> 
						</td>
					</tr>
					<tr>
						<td>
							<p><xsl:value-of select="$Text_testplan_probability_factor"/>:</p>
						</td>
						<td>
							<xsl:if test="@probability_factor &gt; 0">
								<xsl:value-of select="@probability_factor"/>
							</xsl:if>
							<xsl:if test="not (@probability_factor)">
								<xsl:text>n/a</xsl:text>
							</xsl:if>
							<xsl:if test="@probability_factor &lt;= 0">
								<xsl:text>n/a</xsl:text>
							</xsl:if>  
						</td>
					</tr>
					<tr>
						<td>
							<p><xsl:value-of select="$Text_testplan_repair_location"/>:</p>
						</td>
						<td>
							<xsl:if test="@repair_location = '0'">
							    <xsl:value-of select="$Text_testplan_repair_location_garage"/>
							</xsl:if>
							<xsl:if test="@repair_location = '1'">
							    <xsl:value-of select="$Text_testplan_repair_location_mobile"/>
							</xsl:if>
							<xsl:if test="@repair_location = '2'">
							    <xsl:value-of select="$Text_testplan_repair_location_remote"/>
							</xsl:if>
						</td>
					</tr>
				</table>
			
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>	
</xsl:stylesheet>
