<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="function_templates.xsl"/>
	<!-- *************************************************** Versionsvariablen *************** -->
	<!-- %version: 16 %  (for a complete list use Synergy/CCM)                                 -->
	<!-- *************************************************** Versionsvariablen *************** -->
	<xsl:variable name="V_Stylesheet_Version_worksteps" select="'1.5'"/>
	<xsl:variable name="V_Stylesheet_Datum_worksteps" select="'29.09.2021'"/>
	<!-- **************************************************************************************************************************** -->
	<!-- template T_worksteps-->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_worksteps">
		<xsl:call-template name="func_treeView_mark_start">
			<xsl:with-param name="id">worksteps</xsl:with-param>
		</xsl:call-template>
		<p class="default_style_b">
			<xsl:call-template name="func_treeView_label">
				<xsl:with-param name="id">worksteps</xsl:with-param>
				<xsl:with-param name="label"><span class="header_style_middle_bu"><xsl:value-of select="$Text_worksteps"/></span></xsl:with-param>
			</xsl:call-template>
		</p>
		<table class="treeView_content" style="width:165mm">
			<!-- headline -->
			<thead>
				<tr>
					<th>
						<xsl:value-of select="$Text_workstep_number"/>
					</th>
					<th>
						<xsl:value-of select="$Text_workstep_mask"/>
					</th>
					<th>
						<xsl:value-of select="$Text_workstep_result"/>
					</th>
				</tr>
			</thead>
			<!-- data -->
			<xsl:for-each select="guided_fault_finding/diagnosis_log/work_step_data">
				<tr>
					<td>
						<p>
							<xsl:value-of select="./work_step_number"/>
						</p></td>
					<!-- work-step timestamp -->
					<td>
						<p>
						<xsl:variable name="maskTranslated">
							<xsl:choose>
								<xsl:when test="$ReplaceI18nPlaceholder = '0'">
									<xsl:value-of select="./mask"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="translatePlaceholder">
										<xsl:with-param name="input" select="./mask" />
										<xsl:with-param name="position" select="0" />
										<xsl:with-param name="translations" select="./mask_parameters" />
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:call-template name="crlf-replace">
							<xsl:with-param name="subject">
								<xsl:value-of disable-output-escaping="yes" select="$maskTranslated" />
							</xsl:with-param>
						</xsl:call-template>
							<xsl:if test="string-length(./work_step_start_time/date/day)>0">&#160;
								<xsl:call-template name="T_two_digit">
									<xsl:with-param name="P_string">
										<xsl:value-of select="./work_step_start_time/date/day"/>
									</xsl:with-param>
								</xsl:call-template>.<xsl:call-template name="T_two_digit">
									<xsl:with-param name="P_string">
										<xsl:value-of select="./work_step_start_time/date/month"/>
									</xsl:with-param>
								</xsl:call-template>.<xsl:value-of select="./work_step_start_time/date/year"/>&#160;
								<xsl:call-template name="T_two_digit">
									<xsl:with-param name="P_string">
										<xsl:value-of select="./work_step_start_time/time/hours"/>
									</xsl:with-param>
								</xsl:call-template>:<xsl:call-template name="T_two_digit">
									<xsl:with-param name="P_string">
										<xsl:value-of select="./work_step_start_time/time/minutes"/>
									</xsl:with-param>
								</xsl:call-template>:<xsl:call-template name="T_two_digit">
									<xsl:with-param name="P_string">
										<xsl:value-of select="./work_step_start_time/time/seconds"/>
									</xsl:with-param>
								</xsl:call-template>
							</xsl:if>
							<xsl:if test="string-length(./function_test_id)>0">&#160;
								<xsl:call-template name="func_hyperref_label">
									<xsl:with-param name="id">
										<!-- Find the position (order number) of this function test (relative to other function tests with the same id) -->
										<xsl:variable name="currentTestID" select="./function_test_id"/>
										<xsl:variable name="currentWorkstep" select="."/>
										<xsl:variable name="orderNumberOfFunctionTest">
											<xsl:for-each select="./../work_step_data[function_test_id = $currentTestID]">
												<xsl:if test="$currentWorkstep = ."><xsl:value-of select="position()" /></xsl:if>
											</xsl:for-each>
										</xsl:variable>

										<xsl:for-each select="./../function_test[./function_test_id = $currentTestID]">
											<xsl:if test="$orderNumberOfFunctionTest = position()"><xsl:value-of select="generate-id(.)" /></xsl:if>
										</xsl:for-each>
									</xsl:with-param>
									<xsl:with-param name="link"><xsl:value-of select="./function_test_id"/></xsl:with-param>
								</xsl:call-template>
							</xsl:if></p>
					</td>
					<td>
						<p>
							<xsl:value-of select="./result"/></p>
					</td>
				</tr>
				<xsl:if test="./origin/type != 'System'">
				<tr>
					<td>&#160;</td>
					<td>
						<p>
							<xsl:text/><xsl:value-of select="$Text_workstep_origin"/>:&#160;<xsl:text/>
							<xsl:choose>
								<xsl:when test="./origin/type='TPI'">
									<xsl:text/><xsl:value-of select="$Text_workstep_origin_tpi"/><xsl:text/>
								</xsl:when>
								<xsl:when test="./origin/type='EFA'">
									<xsl:text/><xsl:value-of select="$Text_workstep_origin_efa"/><xsl:text/>
								</xsl:when>
								<xsl:when test="./origin/type='GFF'">
									<xsl:text/><xsl:value-of select="$Text_workstep_origin_gff"/><xsl:text/>
								</xsl:when>
								<xsl:when test="./origin/type='System'">
									<xsl:text/><xsl:value-of select="$Text_workstep_origin_system"/><xsl:text/>
								</xsl:when>
								<xsl:when test="./origin/type='System_plan'">
									<xsl:text/><xsl:value-of select="$Text_workstep_origin_systemplan"/><xsl:text/>
								</xsl:when>
								<xsl:when test="./origin/type='Moduleselect'">
									<xsl:text/><xsl:value-of select="$Text_workstep_origin_moduleselect"/><xsl:text/>
								</xsl:when>
								<xsl:when test="./origin/type='Verdacht'">
									<xsl:text/><xsl:value-of select="$Text_workstep_origin_Verdacht"/><xsl:text/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:text/><xsl:value-of select="./origin/type"/><xsl:text/>
								</xsl:otherwise>
							</xsl:choose></p>
					</td>
					<td>&#160;</td>
				</tr>
				</xsl:if>
				<!-- exists efa?-->
				<xsl:for-each select="./origin/efa">					  
				<xsl:if test="string-length(origin_status)>0">
					<tr>
						<td>&#160;</td>
						<td>
							<p>
								<xsl:value-of select="$Text_workstep_origin_efa_origin_status"/>:&#160;<xsl:value-of select="origin_status"/></p>
						</td>
						<td>&#160;</td>
					</tr>
					<tr>
						<td>&#160;</td>
						<td>
							<p>
								<xsl:value-of select="$Text_workstep_origin_efa_efa_objectID"/>:&#160;<xsl:value-of select="efa_objectID"/></p>
						</td>
					</tr>
					<tr>
						<td>&#160;</td>
						<td>
							<p>
								<xsl:value-of select="$Text_workstep_origin_efa_efa_errorTypeID"/>:&#160;<xsl:value-of select="efa_errorTypeID"/></p>
						</td>
					</tr>
					<tr>
						<td>&#160;</td>
						<td>
							<p>
								<xsl:value-of select="$Text_workstep_origin_efa_efa_errorLocationID"/>:&#160;<xsl:value-of select="efa_errorLocationID"/></p>
						</td>
					</tr>
					<tr>
						<td>&#160;</td>
						<td>
							<p>
								<xsl:value-of select="$Text_workstep_origin_efa_efa_errorConditionID"/>:
								<xsl:for-each select="efa_errorConditionID">
									&#160;<xsl:value-of select="."/>
								</xsl:for-each></p>
						</td>
					</tr>
				</xsl:if>						
				</xsl:for-each>				
				<!-- exists tpi?-->
				<xsl:if test="string-length(./origin/tpi/tpi_id)>0">
					<tr>
						<td>&#160;</td>
						<td>
							<p>
								<xsl:value-of select="$Text_workstep_origin_tpi"/>:&#160;<xsl:value-of select="./origin/tpi/tpi_id"/></p>
						</td>
						<td>&#160;</td>
					</tr>
				</xsl:if>
				<!-- exists Verdacht?-->
				<xsl:if test="string-length(./origin/Verdacht/function_test_runtime_id)>0">
					<tr>
						<td>&#160;</td>
						<td>
							<p>
								<xsl:value-of select="$Text_workstep_origin_Verdacht"/>:&#160;<xsl:value-of select="./origin/Verdacht/function_test_runtime_id"/></p>
						</td>
						<td>&#160;</td>
					</tr>
				</xsl:if>
			</xsl:for-each>
		</table>
		<xsl:call-template name="func_treeView_stop"/>
	</xsl:template>

	<!-- **************************************************************************************************************************** -->
	<!-- The template replaces all CRLF of the given string to <BR> tags. -->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="crlf-replace">
		<xsl:param name="subject"/>
	    <xsl:variable name="crlf" select="'&#xA;'"/>
    	<xsl:choose>
	    	<xsl:when test="contains($subject, $crlf)">
    			<xsl:value-of select="substring-before($subject, $crlf)"/><br/>
	    		<xsl:call-template name="crlf-replace">
    	  			<xsl:with-param name="subject" select="substring-after($subject, $crlf)"/>
		    	</xsl:call-template>
      		</xsl:when>
      		<xsl:otherwise>
    			<xsl:value-of select="$subject"/>
      		</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- **************************************************************************************************************************** -->
	<!-- i18n translation, replaces Java placeholders like {0}, {1} with translations. -->
	<!-- **************************************************************************************************************************** -->
  <xsl:template name="translatePlaceholder">
    <xsl:param name="input" />
    <xsl:param name="position" />
    <xsl:param name="translations" />
    <xsl:variable name="replace" select="concat('{', $position, '}')" />
    <xsl:choose>
      <xsl:when test="contains($input, $replace)">
        <xsl:variable name="pos" select="number($position) + 1" />
        <xsl:variable name="with" select="$translations[$pos]" />
        <xsl:call-template name="translatePlaceholder">
          <xsl:with-param name="input" select="concat(substring-before($input, $replace), $with, substring-after($input, $replace))" />
          <xsl:with-param name="position" select="$pos" />
          <xsl:with-param name="translations" select="$translations" />
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$input" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
	
</xsl:stylesheet>
